<?php
/**
 * Test Data Seeder
 * Standalone script to seed test database with sample data
 * 
 * Usage: php tests/seed_test_data.php
 */

require_once __DIR__ . '/bootstrap.php';

echo "Seeding test database...\n";

try {
    TestDatabase::seedTestData();
    echo "✓ Test data seeded successfully!\n";
    
    // Display seeded data summary
    $pdo = TestDatabase::getConnection();
    
    $users = $pdo->query("SELECT COUNT(*) FROM users")->fetchColumn();
    $tiers = $pdo->query("SELECT COUNT(*) FROM subscription_tiers")->fetchColumn();
    
    echo "\nSummary:\n";
    echo "- Users: $users\n";
    echo "- Subscription Tiers: $tiers\n";
    
} catch (Exception $e) {
    echo "✗ Error seeding test data: " . $e->getMessage() . "\n";
    exit(1);
}

