<?php
/**
 * Test Bootstrap File
 * This file is executed before any tests run
 * Sets up the test environment and initializes the test database
 */

// Error reporting for tests
error_reporting(E_ALL);
ini_set('display_errors', '1');

// Define base path
define('BASE_PATH', dirname(__DIR__));

// Load test database configuration
require_once BASE_PATH . '/config/database.test.php';

// Load main database configuration for reference
require_once BASE_PATH . '/config/database.php';

// Load test database helper
require_once __DIR__ . '/TestDatabase.php';

// Initialize test database
if (TEST_RESET_DB) {
    TestDatabase::setup();
}

