<?php
/**
 * User Management Tests
 */

use PHPUnit\Framework\TestCase;

class UserTest extends TestCase
{
    public function testEmailValidation()
    {
        require_once __DIR__ . '/../../includes/functions.php';
        
        $this->assertTrue(isValidEmail('test@example.com'));
        $this->assertFalse(isValidEmail('invalid-email'));
        $this->assertFalse(isValidEmail('test@'));
    }
    
    public function testPasswordHashing()
    {
        $password = 'testpassword123';
        $hash = password_hash($password, PASSWORD_DEFAULT);
        
        $this->assertTrue(password_verify($password, $hash));
        $this->assertFalse(password_verify('wrongpassword', $hash));
    }
}

