# Test Setup Guide

This directory contains test configuration and utilities for the Marketing Platform.

## Prerequisites

1. **Create Test Database**
   ```sql
   CREATE DATABASE mindsybq_market_test;
   ```

2. **Install PHPUnit** (if not already installed)
   ```bash
   composer install --dev
   ```

3. **Configure Test Database**
   
   Edit `config/database.test.php` and update:
   - `TEST_DB_NAME` - Your test database name
   - `TEST_DB_USER` - Your test database user
   - `TEST_DB_PASS` - Your test database password

## Configuration Files

### `config/database.test.php`
Test database configuration file. Separate from production config to avoid conflicts.

### `tests/bootstrap.php`
Test bootstrap file that runs before each test suite. Sets up the test environment.

### `tests/TestDatabase.php`
Helper class for managing test database:
- `setup()` - Creates tables from schema
- `reset()` - Resets database to initial state
- `truncateAll()` - Clears all tables
- `seedTestData()` - Seeds sample data

### `phpunit.xml`
PHPUnit configuration file.

## Running Tests

### Run All Tests
```bash
vendor/bin/phpunit
```

### Run Specific Test Suite
```bash
vendor/bin/phpunit --testsuite Unit
vendor/bin/phpunit --testsuite Integration
```

### Run Specific Test File
```bash
vendor/bin/phpunit tests/Unit/ExampleTest.php
```

## Manual Database Setup

If you need to manually set up the test database:

```bash
php tests/seed_test_data.php
```

## Test Data

Default test users:
- **Admin**: `admin@test.com` / `test123`
- **Client**: `client@test.com` / `test123`

Subscription tiers are automatically seeded from the schema.

## Creating Tests

### Unit Test Example
```php
<?php

use PHPUnit\Framework\TestCase;

class ExampleTest extends TestCase
{
    public function testSomething()
    {
        $this->assertTrue(true);
    }
}
```

### Integration Test with Database
```php
<?php

use PHPUnit\Framework\TestCase;
use TestDatabase;

class DatabaseTest extends TestCase
{
    protected function setUp(): void
    {
        TestDatabase::reset();
    }
    
    public function testDatabaseConnection()
    {
        $pdo = TestDatabase::getConnection();
        $this->assertNotNull($pdo);
    }
}
```

## Notes

- The test database is completely separate from production
- Set `TEST_RESET_DB = true` to automatically recreate tables on each run
- Set `TEST_SEED_DATA = true` to automatically seed test data
- Foreign key constraints are respected in test database

