<?php
/**
 * Database Integration Tests
 */

use PHPUnit\Framework\TestCase;
use TestDatabase;

class DatabaseTest extends TestCase
{
    protected function setUp(): void
    {
        TestDatabase::reset();
    }
    
    public function testDatabaseConnection()
    {
        $pdo = TestDatabase::getConnection();
        $this->assertNotNull($pdo);
    }
    
    public function testUserCreation()
    {
        $pdo = TestDatabase::getConnection();
        
        $passwordHash = password_hash('test123', PASSWORD_DEFAULT);
        $stmt = $pdo->prepare("
            INSERT INTO users (email, password_hash, business_name, contact_name, role, status)
            VALUES (?, ?, ?, ?, 'client', 'active')
        ");
        
        $result = $stmt->execute(['test@example.com', $passwordHash, 'Test Business', 'Test User']);
        $this->assertTrue($result);
    }
}

