<?php
/**
 * Terms of Service and Software License Agreement
 * For AI-IT Inc Marketing Platform
 */

// Allow access without authentication for public terms of service
$pageTitle = 'Terms of Service';

// Minimal header for terms of service (no auth required)
if (!function_exists('url')) {
    require_once __DIR__ . '/includes/base_path.php';
}
if (!function_exists('escape')) {
    function escape($string) {
        return htmlspecialchars($string, ENT_QUOTES, 'UTF-8');
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= escape($pageTitle) ?> - AI-IT Inc Marketing Platform</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.0/font/bootstrap-icons.css">
    <style>
        body { padding-top: 20px; }
        .terms-section { margin-bottom: 3rem; }
        .terms-section h2 { color: #0d6efd; border-bottom: 2px solid #0d6efd; padding-bottom: 10px; margin-bottom: 20px; }
        .terms-section h3 { color: #495057; margin-top: 25px; margin-bottom: 15px; }
        .highlight-box { background-color: #f8f9fa; border-left: 4px solid #0d6efd; padding: 15px; margin: 20px 0; }
    </style>
</head>
<body>
    <nav class="navbar navbar-expand-lg navbar-dark bg-primary mb-4">
        <div class="container">
            <a class="navbar-brand" href="<?= url('index.php') ?>">
                <i class="bi bi-file-earmark-text"></i> AI-IT Inc - Terms of Service
            </a>
        </div>
    </nav>

<div class="container py-5">
    <div class="row">
        <div class="col-lg-10 mx-auto">
            <h1 class="mb-4">Terms of Service and Software License Agreement</h1>
            <p class="text-muted"><strong>Effective Date:</strong> <?= date('F j, Y') ?></p>
            <p class="text-muted"><strong>Last Updated:</strong> <?= date('F j, Y') ?></p>
            <p class="text-muted"><strong>Company:</strong> AI-IT Inc</p>
            
            <div class="highlight-box">
                <p class="mb-0"><strong>Website:</strong> <?= isset($_SERVER['HTTP_HOST']) ? escape($_SERVER['HTTP_HOST']) : 'YourPlatformDomain.com' ?></p>
                <p class="mb-0"><strong>Email:</strong> <a href="mailto:support@ai-itinc.com">support@ai-itinc.com</a></p>
                <p class="mb-0"><strong>Data Protection Officer:</strong> <a href="mailto:dpo@ai-itinc.com">dpo@ai-itinc.com</a></p>
            </div>
            
            <hr class="my-4">
            
            <section class="terms-section">
                <h2>1. Agreement Overview</h2>
                <p>
                    These Terms of Service ("Agreement") constitute a legal agreement between you ("Customer," "User," or "You") and AI-IT Inc ("Company," "We," "Our," or "Us"), governing your use of the AI-IT Inc Marketing Platform CRM and marketing automation services (the "Service").
                </p>
                <p>
                    By accessing, registering for, or using the Service, you agree to be bound by this Agreement and our Privacy Policy. If you do not agree to these terms, do not access or use the Service.
                </p>
                <p>
                    This Agreement applies to all users of the Service, including clients, administrators, and affiliates. If you are accessing the Service on behalf of an organization, you represent and warrant that you have authority to bind that organization to this Agreement.
                </p>
            </section>
            
            <section class="terms-section">
                <h2>2. License Grant</h2>
                <p>
                    Subject to payment of applicable fees (where required) and compliance with these Terms, AI-IT Inc grants you a limited, non-exclusive, non-transferable, revocable license to access and use the Service for your internal business purposes during the term of your subscription.
                </p>
                
                <h3>2.1 Permitted Use</h3>
                <p>You may use the Service to:</p>
                <ul>
                    <li>Create and manage marketing campaigns across multiple channels</li>
                    <li>Manage customer relationships and email lists</li>
                    <li>Integrate with third-party advertising platforms (Google Ads, Facebook Ads)</li>
                    <li>Generate reports and analytics on your marketing performance</li>
                    <li>Send email campaigns to customers who have consented to receive communications</li>
                </ul>
                
                <h3>2.2 Restrictions</h3>
                <p>You may NOT:</p>
                <ul>
                    <li>Copy, modify, distribute, or create derivative works based on the Service</li>
                    <li>Reverse engineer, decompile, disassemble, or attempt to extract source code from the Service</li>
                    <li>Use the Service to build, develop, or support a competing product or service</li>
                    <li>Resell, sublicense, lease, or grant access to the Service to any third party</li>
                    <li>Use the Service for any illegal, fraudulent, or unauthorized purpose</li>
                    <li>Interfere with or disrupt the integrity or performance of the Service</li>
                    <li>Attempt to gain unauthorized access to the Service or related systems</li>
                    <li>Use automated scripts, bots, or scrapers to access the Service</li>
                    <li>Share your account credentials with others</li>
                </ul>
                
                <p>
                    All rights not expressly granted to you in this Agreement are reserved by AI-IT Inc and its licensors.
                </p>
            </section>
            
            <section class="terms-section">
                <h2>3. Ownership and Intellectual Property</h2>
                
                <h3>3.1 Company Property</h3>
                <p>
                    All intellectual property rights in and to the Service, including but not limited to:
                </p>
                <ul>
                    <li>Software, code, algorithms, and technical implementations</li>
                    <li>Design, user interface, graphics, and visual elements</li>
                    <li>Trademarks, service marks, logos, and branding</li>
                    <li>Documentation, help guides, and training materials</li>
                    <li>Analytics, insights, and aggregated data (when anonymized)</li>
                </ul>
                <p>
                    ...are owned by AI-IT Inc or its licensors and are protected by copyright, trademark, patent, and other intellectual property laws.
                </p>
                
                <h3>3.2 Your Content</h3>
                <p>
                    You retain all ownership rights to your content and customer data that you submit, upload, or store within the Service, including:
                </p>
                <ul>
                    <li>Campaign names, descriptions, and marketing content</li>
                    <li>Customer email lists and contact information</li>
                    <li>Ad designs and creative materials</li>
                    <li>Business data and analytics specific to your account</li>
                </ul>
                <p>
                    By using the Service, you grant AI-IT Inc a limited, non-exclusive license to use, store, and process your content solely for the purpose of providing and improving the Service.
                </p>
            </section>
            
            <section class="terms-section">
                <h2>4. Third-Party Integrations (Google, Meta/Facebook, etc.)</h2>
                
                <h3>4.1 Third-Party Services</h3>
                <p>
                    The Service integrates with third-party platforms and APIs, including but not limited to:
                </p>
                <ul>
                    <li><strong>Google Services:</strong> Google Ads API, Google Analytics API</li>
                    <li><strong>Meta Services:</strong> Facebook Ads API, Instagram Ads API</li>
                    <li><strong>Email Services:</strong> SendGrid, Mailchimp, SMTP providers</li>
                    <li><strong>Other Services:</strong> Payment processors, cloud storage providers</li>
                </ul>
                
                <h3>4.2 Third-Party Terms</h3>
                <p>
                    Your use of these integrations is subject to the respective terms and policies of each third-party provider, including:
                </p>
                <ul>
                    <li><a href="https://developers.google.com/terms/api-services-user-data-policy" target="_blank">Google API Services User Data Policy</a></li>
                    <li><a href="https://developers.google.com/terms" target="_blank">Google API Terms of Service</a></li>
                    <li><a href="https://developers.facebook.com/policy" target="_blank">Meta Platform Terms and Developer Policies</a></li>
                    <li><a href="https://www.facebook.com/privacy/explanation" target="_blank">Meta Privacy Policy</a></li>
                </ul>
                
                <div class="highlight-box">
                    <h4>Important: Limited Use Policy Compliance</h4>
                    <p>By using Google or Meta integrations, you agree:</p>
                    <ul>
                        <li>To comply with the <strong>Limited Use Policy</strong> and App Review requirements of each platform</li>
                        <li>That any data obtained from Google or Meta APIs is used <strong>solely</strong> for the purpose explicitly authorized by the user</li>
                        <li><strong>Not</strong> to share, resell, or use API data for advertising, analytics, or machine learning training (except as explicitly permitted by the API provider)</li>
                        <li>To revoke access immediately upon user request or account termination</li>
                        <li>To respect API rate limits, data retention policies, and branding guidelines</li>
                    </ul>
                </div>
                
                <h3>4.3 Third-Party Responsibility</h3>
                <p>
                    AI-IT Inc is not responsible for:
                </p>
                <ul>
                    <li>Any actions, data handling, or policies of Google, Meta, or other third-party services</li>
                    <li>Changes to third-party APIs that may affect Service functionality</li>
                    <li>Discontinuation of third-party services or API access</li>
                    <li>Third-party service outages or technical issues</li>
                </ul>
                <p>
                    You are responsible for maintaining valid API credentials and complying with third-party terms of service. We reserve the right to suspend or disable integrations if we become aware of violations of third-party terms.
                </p>
            </section>
            
            <section class="terms-section">
                <h2>5. Data Protection and Privacy</h2>
                
                <h3>5.1 Privacy Policy</h3>
                <p>
                    We process personal data in accordance with our <a href="<?= url('privacy-policy.php') ?>">Privacy Policy</a> and applicable data protection laws, including:
                </p>
                <ul>
                    <li>General Data Protection Regulation (GDPR) - European Union</li>
                    <li>California Consumer Privacy Act (CCPA) - California, USA</li>
                    <li>Other applicable regional and national data protection regulations</li>
                </ul>
                
                <h3>5.2 Data Security</h3>
                <p>
                    We implement industry-standard security measures to protect your data:
                </p>
                <ul>
                    <li>Encryption of data in transit (SSL/TLS) and at rest</li>
                    <li>Secure authentication and access controls</li>
                    <li>Regular security assessments and updates</li>
                    <li>Limited access to personal data on a need-to-know basis</li>
                    <li>Secure backup and recovery procedures</li>
                </ul>
                
                <h3>5.3 Data Ownership</h3>
                <p>
                    You own your CRM and marketing data. We only process your data to provide, maintain, and improve the Service. Upon termination of your account, you may request export of your data in a standard format.
                </p>
                
                <h3>5.4 Your Responsibilities</h3>
                <p>You are responsible for:</p>
                <ul>
                    <li>Obtaining proper consent from your end-users for any marketing communications sent through the Service</li>
                    <li>Complying with applicable email marketing laws (CAN-SPAM, GDPR, CASL, etc.)</li>
                    <li>Maintaining accurate and up-to-date customer data</li>
                    <li>Implementing appropriate security measures for your account credentials</li>
                </ul>
                
                <h3>5.5 Data Processing Addendum (DPA)</h3>
                <p>
                    A Data Processing Addendum (DPA) is available upon request for enterprise accounts or customers requiring additional data protection assurances. Contact <a href="mailto:dpo@ai-itinc.com">dpo@ai-itinc.com</a> to request a DPA.
                </p>
            </section>
            
            <section class="terms-section">
                <h2>6. User Responsibilities</h2>
                <p>You agree to:</p>
                <ul>
                    <li>Provide accurate, current, and complete information when creating and maintaining your account</li>
                    <li>Maintain the security and confidentiality of your account credentials</li>
                    <li>Notify us immediately of any unauthorized access to or use of your account</li>
                    <li>Use the Service only for lawful business purposes and in compliance with all applicable laws</li>
                    <li>Not misuse, overload, or attempt to circumvent system restrictions or security measures</li>
                    <li>Not use the Service to send spam, unsolicited emails, or malicious content</li>
                    <li>Respect intellectual property rights of others and AI-IT Inc</li>
                </ul>
                
                <h3>6.1 API Integration Requirements</h3>
                <p>If you integrate with Google, Meta, or similar APIs, you must:</p>
                <ul>
                    <li>Obtain and maintain proper OAuth user consent for API access</li>
                    <li>Respect the API provider's rate limits, data retention, and branding policies</li>
                    <li>Comply with all applicable API terms of service and developer policies</li>
                    <li>Promptly revoke API access when requested by users or upon account termination</li>
                    <li>Not cache or store API data beyond what is necessary for Service functionality</li>
                </ul>
            </section>
            
            <section class="terms-section">
                <h2>7. Subscription and Payment</h2>
                
                <h3>7.1 Subscription Plans</h3>
                <p>
                    The Service is available on a subscription basis ("Subscription"). Subscription plans vary by features, limits, and pricing. Details of available plans are provided at the time of registration or through your account dashboard.
                </p>
                
                <h3>7.2 Billing</h3>
                <p>
                    Subscriptions are billed in advance on a recurring, periodic basis (monthly, quarterly, or annually) as selected during registration. All fees are stated in your selected currency and are exclusive of applicable taxes.
                </p>
                
                <h3>7.3 Payment Terms</h3>
                <ul>
                    <li>Payment is due in advance for each billing period</li>
                    <li>We accept major credit cards and other payment methods as indicated during checkout</li>
                    <li>You are responsible for keeping your payment information up to date</li>
                    <li>Failure to pay may result in suspension or termination of your account</li>
                </ul>
                
                <h3>7.4 Refunds</h3>
                <p>
                    All fees are non-refundable except where required by law or as expressly stated in a separate written agreement. If you cancel your subscription, you will continue to have access to paid features until the end of your current billing period.
                </p>
                
                <h3>7.5 Price Changes</h3>
                <p>
                    We reserve the right to modify subscription prices at any time. Price changes will be communicated to you in advance, and you will have the opportunity to cancel your subscription before the new pricing takes effect.
                </p>
                
                <h3>7.6 Free Trials and Promotional Offers</h3>
                <p>
                    We may offer free trials or promotional subscriptions. Terms specific to such offers will be provided at the time of enrollment. Free trials automatically convert to paid subscriptions unless cancelled before the trial period ends.
                </p>
            </section>
            
            <section class="terms-section">
                <h2>8. Termination</h2>
                
                <h3>8.1 Termination by Us</h3>
                <p>
                    We may suspend or terminate your access to the Service immediately, without prior notice, if you:
                </p>
                <ul>
                    <li>Breach any term of this Agreement</li>
                    <li>Misuse the Service, APIs, or third-party integrations</li>
                    <li>Engage in illegal, fraudulent, or unauthorized activity</li>
                    <li>Fail to pay subscription fees when due</li>
                    <li>Violate any applicable laws or regulations</li>
                    <li>Infringe upon the intellectual property rights of AI-IT Inc or others</li>
                </ul>
                
                <h3>8.2 Termination by You</h3>
                <p>
                    You may terminate this Agreement at any time by closing your account through your account settings or by contacting our support team. Termination takes effect at the end of your current billing period, unless you request immediate termination.
                </p>
                
                <h3>8.3 Effect of Termination</h3>
                <p>Upon termination:</p>
                <ul>
                    <li>Your license and access to the Service will cease immediately (or at the end of your billing period, if terminated by you)</li>
                    <li>You will not be entitled to any refund for unused subscription periods</li>
                    <li>We may retain your data as required by law or for legitimate business purposes (e.g., tax records, dispute resolution)</li>
                    <li>You may request deletion of your data, subject to legal retention requirements</li>
                    <li>Any data export must be completed before termination if you wish to retain your information</li>
                </ul>
                
                <h3>8.4 Survival</h3>
                <p>
                    The following provisions will survive termination: Sections 3 (Ownership), 5 (Data Protection), 9 (Confidentiality), 10 (Disclaimers), 11 (Limitation of Liability), 12 (Indemnification), and 13 (Governing Law).
                </p>
            </section>
            
            <section class="terms-section">
                <h2>9. Confidentiality</h2>
                <p>
                    Both parties agree to protect each other's confidential information and not disclose it to third parties except:
                </p>
                <ul>
                    <li>As required by law or court order</li>
                    <li>To legal and financial advisors under confidentiality obligations</li>
                    <li>With the prior written consent of the disclosing party</li>
                </ul>
                <p>
                    "Confidential Information" includes proprietary business information, technical data, customer lists, pricing, and other non-public information disclosed in connection with this Agreement.
                </p>
                <p>
                    Your customer data and marketing content are considered your Confidential Information. Our software, algorithms, and business practices are our Confidential Information.
                </p>
            </section>
            
            <section class="terms-section">
                <h2>10. Disclaimers</h2>
                
                <h3>10.1 Service Availability</h3>
                <p>
                    The Service is provided "as is" and "as available." We strive to maintain high availability, but we do not guarantee that the Service will be uninterrupted, error-free, or available at all times.
                </p>
                
                <h3>10.2 No Warranties</h3>
                <p>
                    TO THE MAXIMUM EXTENT PERMITTED BY APPLICABLE LAW, AI-IT INC DISCLAIMS ALL WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO:
                </p>
                <ul>
                    <li>WARRANTIES OF MERCHANTABILITY</li>
                    <li>FITNESS FOR A PARTICULAR PURPOSE</li>
                    <li>NON-INFRINGEMENT</li>
                    <li>ACCURACY, COMPLETENESS, OR RELIABILITY OF DATA</li>
                    <li>COMPATIBILITY WITH YOUR SYSTEMS OR THIRD-PARTY SERVICES</li>
                </ul>
                
                <h3>10.3 Third-Party Services</h3>
                <p>
                    We do not warrant or guarantee the availability, accuracy, or performance of third-party services, APIs, or integrations (including Google, Meta, email providers, etc.). We are not responsible for changes made by third parties that affect Service functionality.
                </p>
            </section>
            
            <section class="terms-section">
                <h2>11. Limitation of Liability</h2>
                
                <h3>11.1 Exclusion of Damages</h3>
                <p>
                    TO THE MAXIMUM EXTENT PERMITTED BY APPLICABLE LAW, AI-IT INC WILL NOT BE LIABLE FOR:
                </p>
                <ul>
                    <li>INDIRECT, INCIDENTAL, CONSEQUENTIAL, SPECIAL, OR PUNITIVE DAMAGES</li>
                    <li>LOSS OF PROFITS, REVENUE, BUSINESS OPPORTUNITIES, OR GOODWILL</li>
                    <li>LOSS OR CORRUPTION OF DATA</li>
                    <li>COST OF SUBSTITUTE SERVICES</li>
                    <li>ANY UNAUTHORIZED USE OF GOOGLE OR META API DATA BY THIRD PARTIES</li>
                    <li>DAMAGES RESULTING FROM THIRD-PARTY SERVICE OUTAGES OR CHANGES</li>
                </ul>
                
                <h3>11.2 Limitation of Total Liability</h3>
                <p>
                    TO THE MAXIMUM EXTENT PERMITTED BY APPLICABLE LAW, AI-IT INC'S TOTAL AGGREGATE LIABILITY FOR ALL CLAIMS ARISING OUT OF OR RELATED TO THIS AGREEMENT OR THE SERVICE WILL NOT EXCEED THE TOTAL FEES PAID BY YOU TO AI-IT INC DURING THE TWELVE (12) MONTHS PRECEDING THE FIRST CLAIM.
                </p>
                
                <h3>11.3 Exceptions</h3>
                <p>
                    Some jurisdictions do not allow the exclusion of certain warranties or limitations of liability. In such jurisdictions, our liability will be limited to the maximum extent permitted by law.
                </p>
            </section>
            
            <section class="terms-section">
                <h2>12. Indemnification</h2>
                <p>
                    You agree to indemnify, defend, and hold harmless AI-IT Inc, its officers, directors, employees, affiliates, and licensors from and against any and all claims, damages, losses, liabilities, costs, and expenses (including reasonable attorneys' fees) arising out of or related to:
                </p>
                <ul>
                    <li>Your use or misuse of the Service</li>
                    <li>Your breach of this Agreement</li>
                    <li>Your violation of any third-party API terms or policies (Google, Meta, etc.)</li>
                    <li>Your violation of any applicable laws or regulations</li>
                    <li>Your infringement of any intellectual property or privacy rights</li>
                    <li>Your content, customer data, or marketing activities conducted through the Service</li>
                </ul>
                <p>
                    We reserve the right, at our own expense, to assume the exclusive defense and control of any matter otherwise subject to indemnification by you, in which event you will cooperate with us in asserting any available defenses.
                </p>
            </section>
            
            <section class="terms-section">
                <h2>13. Governing Law and Dispute Resolution</h2>
                
                <h3>13.1 Governing Law</h3>
                <p>
                    This Agreement will be governed by and construed in accordance with the laws of the jurisdiction in which AI-IT Inc is incorporated, without regard to its conflict of law principles.
                </p>
                
                <h3>13.2 Dispute Resolution</h3>
                <p>
                    In the event of any dispute arising out of or relating to this Agreement:
                </p>
                <ul>
                    <li>Both parties agree to first attempt to resolve the dispute through good faith negotiations</li>
                    <li>If negotiation fails, disputes may be resolved through binding arbitration in accordance with applicable arbitration rules, or</li>
                    <li>Through the courts of competent jurisdiction in the jurisdiction where AI-IT Inc is located</li>
                </ul>
                
                <h3>13.3 Class Action Waiver</h3>
                <p>
                    You agree that any dispute resolution proceedings will be conducted only on an individual basis and not as a class, consolidated, or representative action.
                </p>
            </section>
            
            <section class="terms-section">
                <h2>14. Amendments to Terms</h2>
                <p>
                    We may update these Terms of Service from time to time to reflect:
                </p>
                <ul>
                    <li>Changes in our services or business practices</li>
                    <li>Legal or regulatory requirements</li>
                    <li>Clarifications or improvements to existing terms</li>
                </ul>
                <p>
                    We will notify you of material changes by:
                </p>
                <ul>
                    <li>Posting the updated Terms on this page</li>
                    <li>Updating the "Last Updated" date at the top of this Agreement</li>
                    <li>Sending an email notification to registered users (for significant changes)</li>
                    <li>Displaying a notice within the Service dashboard</li>
                </ul>
                <p>
                    <strong>Your continued use of the Service after such modifications constitutes your acknowledgment and acceptance of the revised Terms.</strong> If you do not agree to the updated Terms, you must stop using the Service and terminate your account.
                </p>
            </section>
            
            <section class="terms-section">
                <h2>15. Severability</h2>
                <p>
                    If any provision of this Agreement is found to be invalid, illegal, or unenforceable, the remaining provisions will continue in full force and effect. The invalid provision will be modified to the minimum extent necessary to make it valid and enforceable.
                </p>
            </section>
            
            <section class="terms-section">
                <h2>16. Entire Agreement</h2>
                <p>
                    This Agreement, together with our Privacy Policy, constitutes the entire agreement between you and AI-IT Inc regarding the Service and supersedes all prior or contemporaneous agreements, understandings, or communications.
                </p>
            </section>
            
            <section class="terms-section">
                <h2>17. Waiver</h2>
                <p>
                    No waiver of any term or condition of this Agreement will be effective unless in writing and signed by the party waiving the right. A waiver of any breach will not constitute a waiver of any subsequent breach.
                </p>
            </section>
            
            <section class="terms-section">
                <h2>18. Assignment</h2>
                <p>
                    You may not assign or transfer this Agreement or your rights hereunder without our prior written consent. We may assign this Agreement to an affiliate or in connection with a merger, acquisition, or sale of assets.
                </p>
            </section>
            
            <section class="terms-section">
                <h2>19. Contact Information</h2>
                <p>For questions, concerns, or requests regarding this Agreement, please contact us:</p>
                
                <div class="card mb-3">
                    <div class="card-body">
                        <h5 class="card-title">AI-IT Inc</h5>
                        <p class="mb-1"><strong>General Support:</strong> <a href="mailto:support@ai-itinc.com">support@ai-itinc.com</a></p>
                        <p class="mb-1"><strong>Data Protection Officer (DPO):</strong> <a href="mailto:dpo@ai-itinc.com">dpo@ai-itinc.com</a></p>
                        <p class="mb-0"><strong>Legal Inquiries:</strong> <a href="mailto:legal@ai-itinc.com">legal@ai-itinc.com</a></p>
                    </div>
                </div>
                
                <p>
                    For questions about your account, billing, or technical support, please use the support features available in your account dashboard or contact our support team.
                </p>
            </section>
            
            <hr class="my-4">
            
            <div class="alert alert-warning">
                <strong><i class="bi bi-exclamation-triangle"></i> Important Legal Notice</strong>
                <p class="mb-0 mt-2">
                    This is a legal document. Please read it carefully. By using our Service, you agree to be bound by these Terms. If you do not agree to these Terms, do not use the Service.
                </p>
            </div>
            
            <div class="alert alert-info mt-3">
                <strong><i class="bi bi-info-circle"></i> Related Documents</strong>
                <p class="mb-0 mt-2">
                    Please also review our <a href="<?= url('privacy-policy.php') ?>">Privacy Policy</a> to understand how we collect, use, and protect your information, and our <a href="<?= url('software-license.php') ?>">Software License Agreement</a> for licensing terms.
                </p>
            </div>
        </div>
    </div>
</div>

<footer class="mt-5 py-4 bg-light">
    <div class="container">
        <div class="row">
            <div class="col-md-6">
                <p class="text-muted mb-0">&copy; <?= date('Y') ?> AI-IT Inc. All rights reserved.</p>
            </div>
            <div class="col-md-6 text-end">
                <p class="text-muted mb-0">
                    <a href="<?= url('privacy-policy.php') ?>">Privacy Policy</a> | 
                    <a href="<?= url('terms-of-service.php') ?>">Terms of Service</a> | 
                    <a href="mailto:dpo@ai-itinc.com">Contact DPO</a>
                </p>
            </div>
        </div>
    </div>
</footer>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>

