<?php
/**
 * Software License Agreement
 * For AI-IT Inc Marketing Platform
 */

// Allow access without authentication for public license document
$pageTitle = 'Software License';

// Minimal header for license (no auth required)
if (!function_exists('url')) {
    require_once __DIR__ . '/includes/base_path.php';
}
if (!function_exists('escape')) {
    function escape($string) {
        return htmlspecialchars($string, ENT_QUOTES, 'UTF-8');
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= escape($pageTitle) ?> - AI-IT Inc Marketing Platform</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.0/font/bootstrap-icons.css">
    <style>
        body { padding-top: 20px; }
        .license-section { margin-bottom: 3rem; }
        .license-section h2 { color: #0d6efd; border-bottom: 2px solid #0d6efd; padding-bottom: 10px; margin-bottom: 20px; }
        .license-section h3 { color: #495057; margin-top: 25px; margin-bottom: 15px; }
        .highlight-box { background-color: #f8f9fa; border-left: 4px solid #0d6efd; padding: 15px; margin: 20px 0; }
        .prohibited { background-color: #fff3cd; border-left: 4px solid #ffc107; padding: 15px; margin: 20px 0; }
    </style>
</head>
<body>
    <nav class="navbar navbar-expand-lg navbar-dark bg-primary mb-4">
        <div class="container">
            <a class="navbar-brand" href="<?= url('index.php') ?>">
                <i class="bi bi-shield-check"></i> AI-IT Inc - Software License
            </a>
        </div>
    </nav>

<div class="container py-5">
    <div class="row">
        <div class="col-lg-10 mx-auto">
            <h1 class="mb-4">Software License Agreement</h1>
            <p class="text-muted"><strong>Effective Date:</strong> <?= date('F j, Y') ?></p>
            <p class="text-muted"><strong>Last Updated:</strong> <?= date('F j, Y') ?></p>
            <p class="text-muted"><strong>Licensor:</strong> AI-IT Inc</p>
            
            <div class="highlight-box">
                <p class="mb-0"><strong>Software:</strong> AI-IT Inc Marketing Platform (CRM & Marketing Automation System)</p>
                <p class="mb-0"><strong>License Type:</strong> Proprietary Commercial Software License</p>
                <p class="mb-0"><strong>Licensee:</strong> Authorized users with active subscription accounts</p>
                <p class="mb-0"><strong>Contact:</strong> <a href="mailto:license@ai-itinc.com">license@ai-itinc.com</a></p>
            </div>
            
            <hr class="my-4">
            
            <section class="license-section">
                <h2>1. Grant of License</h2>
                <p>
                    Subject to the terms and conditions of this Software License Agreement ("License"), AI-IT Inc ("Licensor") hereby grants you ("Licensee" or "You") a limited, non-exclusive, non-transferable, revocable license to access and use the AI-IT Inc Marketing Platform software (the "Software") for your internal business purposes.
                </p>
                <p>
                    This license is granted only to authorized users who have:
                </p>
                <ul>
                    <li>Created a valid account with AI-IT Inc</li>
                    <li>Accepted these License terms and our Terms of Service</li>
                    <li>Maintained an active subscription (where applicable) or have been granted free/trial access</li>
                </ul>
            </section>
            
            <section class="license-section">
                <h2>2. License Scope and Restrictions</h2>
                
                <h3>2.1 Permitted Uses</h3>
                <p>You may:</p>
                <ul>
                    <li>Access and use the Software through a web browser or authorized API</li>
                    <li>Create and manage marketing campaigns, customer data, and business content</li>
                    <li>Use integrated third-party services (Google Ads, Facebook Ads, email providers) in accordance with their respective terms</li>
                    <li>Generate reports and analytics for your own business use</li>
                    <li>Store and process your business data within the Software</li>
                    <li>Export your data in standard formats provided by the Software</li>
                </ul>
                
                <div class="prohibited">
                    <h3>2.2 Prohibited Uses</h3>
                    <p><strong>YOU MAY NOT:</strong></p>
                    <ul>
                        <li><strong>Copy or Reproduce:</strong> Copy, duplicate, or reproduce the Software or any portion thereof</li>
                        <li><strong>Modify or Adapt:</strong> Modify, adapt, alter, translate, or create derivative works based on the Software</li>
                        <li><strong>Reverse Engineer:</strong> Reverse engineer, decompile, disassemble, or otherwise attempt to derive the source code of the Software</li>
                        <li><strong>Redistribute:</strong> Sell, rent, lease, sublicense, or otherwise redistribute the Software to third parties</li>
                        <li><strong>Compete:</strong> Use the Software to develop, create, or support any competing product or service</li>
                        <li><strong>Bypass Security:</strong> Attempt to circumvent, disable, or bypass any security features or restrictions of the Software</li>
                        <li><strong>Share Access:</strong> Share your account credentials or allow unauthorized users to access the Software</li>
                        <li><strong>Scrape or Mine:</strong> Use automated scripts, bots, scrapers, or data mining tools to extract data from the Software</li>
                        <li><strong>Resell Services:</strong> Use the Software to provide services to third parties as a service bureau or application service provider</li>
                        <li><strong>Violate Laws:</strong> Use the Software in any manner that violates applicable laws, regulations, or third-party rights</li>
                    </ul>
                </div>
            </section>
            
            <section class="license-section">
                <h2>3. Intellectual Property Rights</h2>
                
                <h3>3.1 Ownership</h3>
                <p>
                    The Software and all intellectual property rights therein, including but not limited to:
                </p>
                <ul>
                    <li>Source code, object code, and compiled applications</li>
                    <li>Algorithms, logic, and programming techniques</li>
                    <li>User interfaces, designs, and graphical elements</li>
                    <li>Documentation, help files, and user guides</li>
                    <li>Trademarks, service marks, logos, and branding</li>
                    <li>Trade secrets and proprietary know-how</li>
                </ul>
                <p>
                    ...are owned exclusively by AI-IT Inc or its licensors and are protected by copyright, trademark, patent, trade secret, and other intellectual property laws.
                </p>
                
                <h3>3.2 Reservation of Rights</h3>
                <p>
                    All rights not expressly granted to you in this License are reserved by AI-IT Inc. This License does not transfer ownership of the Software or any intellectual property rights to you.
                </p>
                
                <h3>3.3 Your Content</h3>
                <p>
                    You retain ownership of your content, data, and materials that you create, upload, or store within the Software. You grant AI-IT Inc a limited, non-exclusive license to use, store, and process your content solely for the purpose of providing the Software services.
                </p>
            </section>
            
            <section class="license-section">
                <h2>4. Subscription and License Duration</h2>
                
                <h3>4.1 Subscription-Based License</h3>
                <p>
                    This License is provided on a subscription basis. Your right to use the Software is contingent upon maintaining an active subscription account with AI-IT Inc.
                </p>
                
                <h3>4.2 License Term</h3>
                <p>
                    The License term begins when you create an account and accept these terms, and continues for the duration of your active subscription. Free trial periods, if offered, are subject to the same License terms.
                </p>
                
                <h3>4.3 License Renewal</h3>
                <p>
                    Your License renews automatically with each subscription renewal, provided your account remains in good standing and you continue to comply with this License and our Terms of Service.
                </p>
                
                <h3>4.4 License Termination</h3>
                <p>
                    This License terminates immediately upon:
                </p>
                <ul>
                    <li>Expiration or cancellation of your subscription</li>
                    <li>Breach of any term of this License</li>
                    <li>Violation of our Terms of Service</li>
                    <li>Termination by AI-IT Inc for any reason</li>
                </ul>
                <p>
                    Upon termination, you must immediately cease all use of the Software and delete any copies of Software documentation or materials in your possession.
                </p>
            </section>
            
            <section class="license-section">
                <h2>5. Updates and Modifications</h2>
                
                <h3>5.1 Software Updates</h3>
                <p>
                    AI-IT Inc may, from time to time, provide updates, patches, enhancements, or modifications to the Software. Such updates may be automatically applied or may require your action. Updates are provided under the terms of this License.
                </p>
                
                <h3>5.2 Feature Changes</h3>
                <p>
                    AI-IT Inc reserves the right to modify, add, remove, or discontinue features of the Software at any time with or without notice. We will make reasonable efforts to notify users of significant changes that may affect their use of the Software.
                </p>
                
                <h3>5.3 License Terms Updates</h3>
                <p>
                    We may update this License Agreement from time to time. Updated terms will be posted on this page with a revised "Last Updated" date. Continued use of the Software after such updates constitutes your acceptance of the revised License terms.
                </p>
            </section>
            
            <section class="license-section">
                <h2>6. Support and Maintenance</h2>
                
                <h3>6.1 Support Services</h3>
                <p>
                    Support for the Software is provided in accordance with your subscription plan and our Terms of Service. Support may include:
                </p>
                <ul>
                    <li>Technical assistance via email or support portal</li>
                    <li>Documentation and user guides</li>
                    <li>Bug fixes and security patches</li>
                    <li>Feature updates and enhancements</li>
                </ul>
                
                <h3>6.2 Maintenance Windows</h3>
                <p>
                    AI-IT Inc may perform scheduled maintenance on the Software, which may result in temporary unavailability. We will provide reasonable notice of scheduled maintenance when possible.
                </p>
                
                <h3>6.3 No Guarantee of Availability</h3>
                <p>
                    While we strive to maintain high availability, AI-IT Inc does not guarantee uninterrupted access to the Software. The Software is provided "as is" without warranties of any kind.
                </p>
            </section>
            
            <section class="license-section">
                <h2>7. Warranty Disclaimer</h2>
                
                <div class="prohibited">
                    <p>
                        <strong>THE SOFTWARE IS PROVIDED "AS IS" AND "AS AVAILABLE" WITHOUT WARRANTIES OF ANY KIND, WHETHER EXPRESS, IMPLIED, STATUTORY, OR OTHERWISE.</strong>
                    </p>
                    <p>
                        TO THE MAXIMUM EXTENT PERMITTED BY APPLICABLE LAW, AI-IT INC DISCLAIMS ALL WARRANTIES, INCLUDING BUT NOT LIMITED TO:
                    </p>
                    <ul>
                        <li>WARRANTIES OF MERCHANTABILITY</li>
                        <li>FITNESS FOR A PARTICULAR PURPOSE</li>
                        <li>NON-INFRINGEMENT</li>
                        <li>ACCURACY, COMPLETENESS, OR RELIABILITY</li>
                        <li>ERROR-FREE OR UNINTERRUPTED OPERATION</li>
                        <li>COMPATIBILITY WITH YOUR SYSTEMS OR THIRD-PARTY SERVICES</li>
                        <li>SECURITY OF DATA TRANSMISSION OR STORAGE</li>
                    </ul>
                </div>
                
                <p>
                    Some jurisdictions do not allow the exclusion of certain warranties. In such jurisdictions, some of the above exclusions may not apply to you, and you may have additional rights.
                </p>
            </section>
            
            <section class="license-section">
                <h2>8. Limitation of Liability</h2>
                
                <h3>8.1 Exclusion of Damages</h3>
                <p>
                    TO THE MAXIMUM EXTENT PERMITTED BY APPLICABLE LAW, AI-IT INC SHALL NOT BE LIABLE FOR:
                </p>
                <ul>
                    <li>INDIRECT, INCIDENTAL, CONSEQUENTIAL, SPECIAL, OR PUNITIVE DAMAGES</li>
                    <li>LOSS OF PROFITS, REVENUE, BUSINESS OPPORTUNITIES, OR GOODWILL</li>
                    <li>LOSS OR CORRUPTION OF DATA</li>
                    <li>COST OF SUBSTITUTE SOFTWARE OR SERVICES</li>
                    <li>DAMAGES ARISING FROM UNAUTHORIZED ACCESS OR USE</li>
                    <li>DAMAGES RESULTING FROM THIRD-PARTY SERVICE FAILURES OR CHANGES</li>
                </ul>
                
                <h3>8.2 Maximum Liability</h3>
                <p>
                    TO THE MAXIMUM EXTENT PERMITTED BY APPLICABLE LAW, AI-IT INC'S TOTAL AGGREGATE LIABILITY FOR ALL CLAIMS ARISING OUT OF OR RELATED TO THIS LICENSE OR THE SOFTWARE SHALL NOT EXCEED THE TOTAL FEES PAID BY YOU TO AI-IT INC FOR THE SOFTWARE DURING THE TWELVE (12) MONTHS PRECEDING THE FIRST CLAIM.
                </p>
                
                <h3>8.3 Data Backup</h3>
                <p>
                    YOU ARE RESPONSIBLE FOR MAINTAINING BACKUPS OF YOUR DATA. AI-IT INC SHALL NOT BE LIABLE FOR ANY LOSS OF DATA, REGARDLESS OF THE CAUSE.
                </p>
            </section>
            
            <section class="license-section">
                <h2>9. Indemnification</h2>
                <p>
                    You agree to indemnify, defend, and hold harmless AI-IT Inc, its officers, directors, employees, affiliates, and licensors from and against any and all claims, damages, losses, liabilities, costs, and expenses (including reasonable attorneys' fees) arising out of or related to:
                </p>
                <ul>
                    <li>Your use or misuse of the Software</li>
                    <li>Your breach of this License Agreement</li>
                    <li>Your violation of any applicable laws or regulations</li>
                    <li>Your infringement of any intellectual property or privacy rights</li>
                    <li>Your content or data stored within the Software</li>
                </ul>
            </section>
            
            <section class="license-section">
                <h2>10. Export Restrictions</h2>
                <p>
                    The Software may be subject to export control laws and regulations. You agree to comply with all applicable export and import laws and regulations. You represent that you are not located in a country that is subject to a U.S. or EU government embargo, or that has been designated as a "terrorist supporting" country, and that you are not listed on any U.S. or EU government list of prohibited or restricted parties.
                </p>
            </section>
            
            <section class="license-section">
                <h2>11. Third-Party Components</h2>
                <p>
                    The Software may include third-party open source software components or libraries. Such components are subject to their respective open source licenses, which may have different terms than this License. A list of third-party components and their licenses is available upon request.
                </p>
                <p>
                    Third-party components are provided "as is" and AI-IT Inc makes no warranties regarding such components.
                </p>
            </section>
            
            <section class="license-section">
                <h2>12. Audit Rights</h2>
                <p>
                    AI-IT Inc reserves the right to audit your use of the Software to ensure compliance with this License. You agree to cooperate with any such audit and provide reasonable access to relevant records and systems.
                </p>
            </section>
            
            <section class="license-section">
                <h2>13. Assignment</h2>
                <p>
                    You may not assign, sublicense, or transfer this License or your rights hereunder without the prior written consent of AI-IT Inc. AI-IT Inc may assign this License to an affiliate or in connection with a merger, acquisition, or sale of assets.
                </p>
            </section>
            
            <section class="license-section">
                <h2>14. Severability</h2>
                <p>
                    If any provision of this License is found to be invalid, illegal, or unenforceable, the remaining provisions will continue in full force and effect. The invalid provision will be modified to the minimum extent necessary to make it valid and enforceable.
                </p>
            </section>
            
            <section class="license-section">
                <h2>15. Entire Agreement</h2>
                <p>
                    This License, together with our Terms of Service and Privacy Policy, constitutes the entire agreement between you and AI-IT Inc regarding the Software and supersedes all prior or contemporaneous agreements, understandings, or communications.
                </p>
            </section>
            
            <section class="license-section">
                <h2>16. Governing Law</h2>
                <p>
                    This License will be governed by and construed in accordance with the laws of the jurisdiction in which AI-IT Inc is incorporated, without regard to its conflict of law principles.
                </p>
            </section>
            
            <section class="license-section">
                <h2>17. Contact Information</h2>
                <p>For questions about this Software License Agreement, please contact:</p>
                
                <div class="card">
                    <div class="card-body">
                        <h5 class="card-title">AI-IT Inc - Licensing</h5>
                        <p class="mb-1"><strong>License Inquiries:</strong> <a href="mailto:license@ai-itinc.com">license@ai-itinc.com</a></p>
                        <p class="mb-1"><strong>General Support:</strong> <a href="mailto:support@ai-itinc.com">support@ai-itinc.com</a></p>
                        <p class="mb-1"><strong>Legal Inquiries:</strong> <a href="mailto:legal@ai-itinc.com">legal@ai-itinc.com</a></p>
                        <p class="mb-0"><strong>Data Protection Officer:</strong> <a href="mailto:dpo@ai-itinc.com">dpo@ai-itinc.com</a></p>
                    </div>
                </div>
            </section>
            
            <hr class="my-4">
            
            <div class="alert alert-warning">
                <strong><i class="bi bi-exclamation-triangle"></i> Important License Notice</strong>
                <p class="mb-0 mt-2">
                    This is a legal document. By accessing or using the Software, you acknowledge that you have read, understood, and agree to be bound by this Software License Agreement. If you do not agree to these terms, you must not access or use the Software.
                </p>
            </div>
            
            <div class="alert alert-info mt-3">
                <strong><i class="bi bi-info-circle"></i> Related Documents</strong>
                <p class="mb-0 mt-2">
                    Please also review our <a href="<?= url('terms-of-service.php') ?>">Terms of Service</a> and <a href="<?= url('privacy-policy.php') ?>">Privacy Policy</a> for complete information about using our platform.
                </p>
            </div>
        </div>
    </div>
</div>

<footer class="mt-5 py-4 bg-light">
    <div class="container">
        <div class="row">
            <div class="col-md-6">
                <p class="text-muted mb-0">&copy; <?= date('Y') ?> AI-IT Inc. All rights reserved.</p>
            </div>
            <div class="col-md-6 text-end">
                <p class="text-muted mb-0">
                    <a href="<?= url('privacy-policy.php') ?>">Privacy Policy</a> | 
                    <a href="<?= url('terms-of-service.php') ?>">Terms of Service</a> | 
                    <a href="<?= url('software-license.php') ?>">Software License</a>
                </p>
            </div>
        </div>
    </div>
</footer>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>


