<?php
/**
 * Setup Check - Redirects to setup wizard if needed
 */

// Check if setup is complete
$setupComplete = file_exists(__DIR__ . '/.setup_complete');

// Check if .env exists
$envExists = file_exists(__DIR__ . '/.env');

// Check if database connection works
$dbOk = false;
if ($envExists) {
    try {
        require_once __DIR__ . '/config/env_loader.php';
        require_once __DIR__ . '/config/database.php';
        
        $dsn = "mysql:host=" . DB_HOST . ";dbname=" . DB_NAME . ";charset=" . DB_CHARSET;
        $pdo = new PDO($dsn, DB_USER, DB_PASS, [
            PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
            PDO::ATTR_TIMEOUT => 2
        ]);
        $pdo->query("SELECT 1");
        
        // Check if tables exist
        $tables = $pdo->query("SHOW TABLES")->fetchAll(PDO::FETCH_COLUMN);
        $dbOk = count($tables) > 0;
    } catch (Exception $e) {
        $dbOk = false;
    }
}

// If setup is not complete or database is not ready, redirect to wizard
if (!$setupComplete || !$envExists || !$dbOk) {
    header('Location: setup_wizard.php');
    exit;
}

// Setup is complete, continue to normal flow
return true;

