<?php
/**
 * Affiliate Referral Landing Page
 * Tracks affiliate clicks and redirects to registration
 */

session_start();
require_once __DIR__ . '/includes/functions.php';
require_once __DIR__ . '/includes/AffiliateTracker.php';

// Get partner code from URL
$partnerCode = isset($_GET['ref']) ? trim($_GET['ref']) : '';

if (empty($partnerCode)) {
    // No referral code, redirect to normal registration
    header('Location: ' . url('register.php'));
    exit;
}

// Track the click
$tracker = new AffiliateTracker();
$clickId = $tracker->trackClick($partnerCode, $_SERVER['HTTP_REFERER'] ?? null, $_SERVER['REQUEST_URI'] ?? null);

// Redirect to registration with affiliate session active
header('Location: ' . url('register.php'));
exit;

