<?php
/**
 * Privacy Policy Page
 * For AI-IT Inc and integrations with Facebook, Google services
 */

// Allow access without authentication for public privacy policy
$pageTitle = 'Privacy Policy';

// Minimal header for privacy policy (no auth required)
if (!function_exists('url')) {
    require_once __DIR__ . '/includes/base_path.php';
}
if (!function_exists('escape')) {
    function escape($string) {
        return htmlspecialchars($string, ENT_QUOTES, 'UTF-8');
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= escape($pageTitle) ?> - AI-IT Inc Marketing Platform</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.0/font/bootstrap-icons.css">
    <style>
        body { padding-top: 20px; }
        .privacy-section { margin-bottom: 3rem; }
        .privacy-section h2 { color: #0d6efd; border-bottom: 2px solid #0d6efd; padding-bottom: 10px; margin-bottom: 20px; }
        .privacy-section h3 { color: #495057; margin-top: 25px; margin-bottom: 15px; }
    </style>
</head>
<body>
    <nav class="navbar navbar-expand-lg navbar-dark bg-primary mb-4">
        <div class="container">
            <a class="navbar-brand" href="<?= url('index.php') ?>">
                <i class="bi bi-shield-check"></i> AI-IT Inc - Privacy Policy
            </a>
        </div>
    </nav>

<div class="container py-5">
    <div class="row">
        <div class="col-lg-10 mx-auto">
            <h1 class="mb-4">Privacy Policy</h1>
            <p class="text-muted"><strong>Effective Date:</strong> <?= date('F j, Y') ?></p>
            <p class="text-muted"><strong>Last Updated:</strong> <?= date('F j, Y') ?></p>
            
            <hr class="my-4">
            
            <section class="mb-5">
                <h2>1. Introduction</h2>
                <p>
                    AI-IT Inc ("we," "our," or "us") is committed to protecting your privacy. This Privacy Policy explains how we collect, use, disclose, and safeguard your information when you use our marketing platform services, including integrations with Facebook and Google advertising services.
                </p>
                <p>
                    By using our services, you consent to the data practices described in this policy. If you do not agree with the data practices described, please do not use our services.
                </p>
            </section>
            
            <section class="mb-5">
                <h2>2. Information We Collect</h2>
                
                <h3>2.1 Information You Provide to Us</h3>
                <ul>
                    <li><strong>Account Information:</strong> Name, email address, business name, phone number, and billing address</li>
                    <li><strong>Campaign Data:</strong> Campaign names, descriptions, budgets, and performance metrics</li>
                    <li><strong>Content:</strong> Ad designs, email content, and marketing materials you upload</li>
                    <li><strong>Customer Lists:</strong> Email addresses and contact information you import or provide</li>
                </ul>
                
                <h3>2.2 Information Collected Automatically</h3>
                <ul>
                    <li><strong>Usage Data:</strong> IP address, browser type, device information, pages visited, and time spent on pages</li>
                    <li><strong>Tracking Data:</strong> UTM parameters, referral sources, session IDs, and conversion tracking</li>
                    <li><strong>Performance Metrics:</strong> Ad impressions, clicks, conversions, and campaign analytics</li>
                </ul>
                
                <h3>2.3 Information from Third-Party Services</h3>
                <ul>
                    <li><strong>Facebook Ads:</strong> Campaign performance data, audience insights, and ad metrics provided through Facebook Ads API</li>
                    <li><strong>Google Ads:</strong> Campaign statistics, keyword performance, and conversion data from Google Ads API</li>
                    <li><strong>Email Services:</strong> Delivery status, open rates, and click-through rates from email service providers</li>
                </ul>
            </section>
            
            <section class="mb-5">
                <h2>3. How We Use Your Information</h2>
                <p>We use the information we collect for the following purposes:</p>
                <ul>
                    <li>To provide and maintain our marketing platform services</li>
                    <li>To process your transactions and manage your account</li>
                    <li>To create and manage advertising campaigns on Facebook and Google</li>
                    <li>To send email campaigns and track their performance</li>
                    <li>To provide analytics and reporting on your marketing activities</li>
                    <li>To communicate with you about your account, services, and support requests</li>
                    <li>To comply with legal obligations and protect our rights</li>
                    <li>To improve our services and develop new features</li>
                    <li>To prevent fraud and ensure security</li>
                </ul>
            </section>
            
            <section class="mb-5">
                <h2>4. Facebook Integration</h2>
                <p>
                    When you connect your Facebook Ads account to our platform, we may access and collect the following information through Facebook's APIs:
                </p>
                <ul>
                    <li>Campaign data, ad performance metrics, and audience insights</li>
                    <li>Account information necessary to manage your Facebook advertising campaigns</li>
                    <li>Ad creative and targeting information you choose to sync</li>
                </ul>
                <p>
                    <strong>Facebook's Privacy Policy:</strong> Your use of Facebook services is also governed by <a href="https://www.facebook.com/privacy/explanation" target="_blank">Facebook's Privacy Policy</a>. We recommend reviewing Facebook's data practices as they relate to advertising and analytics.
                </p>
                <p>
                    We only access and use Facebook data as necessary to provide our services and in accordance with Facebook's Platform Policy and your authorization.
                </p>
            </section>
            
            <section class="mb-5">
                <h2>5. Google Integration</h2>
                <p>
                    When you connect your Google Ads account to our platform, we may access and collect the following information through Google's APIs:
                </p>
                <ul>
                    <li>Campaign performance data, keyword statistics, and conversion metrics</li>
                    <li>Account information required to manage your Google advertising campaigns</li>
                    <li>Ad groups, keywords, and bidding information you authorize us to access</li>
                </ul>
                <p>
                    <strong>Google's Privacy Policy:</strong> Your use of Google services is also subject to <a href="https://policies.google.com/privacy" target="_blank">Google's Privacy Policy</a>. We encourage you to review Google's privacy practices regarding advertising data.
                </p>
                <p>
                    We only access and use Google data as necessary to provide our services and in accordance with Google's API Terms of Service and your authorization.
                </p>
            </section>
            
            <section class="mb-5">
                <h2>6. Data Sharing and Disclosure</h2>
                <p>We may share your information in the following circumstances:</p>
                
                <h3>6.1 Service Providers</h3>
                <p>We may share data with third-party service providers who perform services on our behalf, including:</p>
                <ul>
                    <li>Cloud hosting and infrastructure providers</li>
                    <li>Email service providers (SendGrid, Mailchimp, SMTP services)</li>
                    <li>Payment processors and billing services</li>
                    <li>Analytics and tracking service providers</li>
                </ul>
                
                <h3>6.2 Business Transfers</h3>
                <p>If we are involved in a merger, acquisition, or sale of assets, your information may be transferred as part of that transaction.</p>
                
                <h3>6.3 Legal Requirements</h3>
                <p>We may disclose information if required by law, court order, or governmental regulation, or to protect our rights and safety.</p>
                
                <h3>6.4 With Your Consent</h3>
                <p>We may share your information with third parties when you explicitly consent to such sharing.</p>
            </section>
            
            <section class="mb-5">
                <h2>7. Data Security</h2>
                <p>
                    We implement appropriate technical and organizational measures to protect your personal information against unauthorized access, alteration, disclosure, or destruction. These measures include:
                </p>
                <ul>
                    <li>Encryption of data in transit (SSL/TLS) and at rest</li>
                    <li>Secure authentication and access controls</li>
                    <li>Regular security assessments and updates</li>
                    <li>Limited access to personal data on a need-to-know basis</li>
                    <li>Secure backup and recovery procedures</li>
                </ul>
                <p>
                    However, no method of transmission over the Internet or electronic storage is 100% secure. While we strive to use commercially acceptable means to protect your information, we cannot guarantee absolute security.
                </p>
            </section>
            
            <section class="mb-5">
                <h2>8. Your Rights (GDPR & CCPA Compliance)</h2>
                <p>Depending on your location, you may have the following rights regarding your personal information:</p>
                
                <h3>8.1 Access and Portability</h3>
                <p>You have the right to access and receive a copy of your personal data.</p>
                
                <h3>8.2 Rectification</h3>
                <p>You can request correction of inaccurate or incomplete personal information.</p>
                
                <h3>8.3 Erasure</h3>
                <p>You may request deletion of your personal information, subject to legal retention requirements.</p>
                
                <h3>8.4 Restriction of Processing</h3>
                <p>You can request that we limit how we process your personal information.</p>
                
                <h3>8.5 Objection to Processing</h3>
                <p>You have the right to object to certain types of processing of your personal information.</p>
                
                <h3>8.6 Withdrawal of Consent</h3>
                <p>Where processing is based on consent, you may withdraw consent at any time.</p>
                
                <h3>8.7 Data Portability</h3>
                <p>You can request that we transfer your data to another service provider in a machine-readable format.</p>
                
                <p>
                    To exercise these rights, please contact our Data Protection Officer at <a href="mailto:dpo@ai-itinc.com">dpo@ai-itinc.com</a>.
                </p>
            </section>
            
            <section class="mb-5">
                <h2>9. Data Retention</h2>
                <p>
                    We retain your personal information for as long as necessary to fulfill the purposes outlined in this Privacy Policy, unless a longer retention period is required or permitted by law. Specifically:
                </p>
                <ul>
                    <li><strong>Account Data:</strong> Retained while your account is active and for a reasonable period afterward</li>
                    <li><strong>Campaign Data:</strong> Retained for the duration of your account and for historical reporting purposes</li>
                    <li><strong>Analytics Data:</strong> Retained for up to 2 years for analysis and reporting</li>
                    <li><strong>Legal Requirements:</strong> Some data may be retained longer if required by law or for legitimate business purposes</li>
                </ul>
            </section>
            
            <section class="mb-5">
                <h2>10. Cookies and Tracking Technologies</h2>
                <p>
                    We use cookies, web beacons, and similar tracking technologies to collect and track information about your use of our services. These technologies help us:
                </p>
                <ul>
                    <li>Remember your preferences and settings</li>
                    <li>Analyze how you use our platform</li>
                    <li>Track campaign performance and conversions</li>
                    <li>Improve our services and user experience</li>
                </ul>
                <p>
                    You can control cookies through your browser settings. However, disabling cookies may limit your ability to use certain features of our platform.
                </p>
                <p>
                    We also use third-party analytics services (such as Google Analytics) that may set their own cookies. Please review their privacy policies for information on how they handle your data.
                </p>
            </section>
            
            <section class="mb-5">
                <h2>11. International Data Transfers</h2>
                <p>
                    Your information may be transferred to and processed in countries other than your country of residence. These countries may have data protection laws that differ from those in your country. When we transfer data internationally, we ensure appropriate safeguards are in place, such as:
                </p>
                <ul>
                    <li>Standard contractual clauses approved by relevant data protection authorities</li>
                    <li>Compliance with applicable data protection laws and regulations</li>
                    <li>Appropriate security measures to protect transferred data</li>
                </ul>
            </section>
            
            <section class="mb-5">
                <h2>12. Children's Privacy</h2>
                <p>
                    Our services are not intended for individuals under the age of 18. We do not knowingly collect personal information from children. If we become aware that we have collected personal information from a child without parental consent, we will take steps to delete that information.
                </p>
            </section>
            
            <section class="mb-5">
                <h2>13. Changes to This Privacy Policy</h2>
                <p>
                    We may update this Privacy Policy from time to time to reflect changes in our practices or for other operational, legal, or regulatory reasons. We will notify you of any material changes by:
                </p>
                <ul>
                    <li>Posting the new Privacy Policy on this page</li>
                    <li>Updating the "Last Updated" date at the top of this policy</li>
                    <li>Sending an email notification to registered users (for significant changes)</li>
                </ul>
                <p>
                    Your continued use of our services after such modifications constitutes your acknowledgment and acceptance of the updated Privacy Policy.
                </p>
            </section>
            
            <section class="mb-5">
                <h2>14. Contact Information</h2>
                <p>If you have questions, concerns, or requests regarding this Privacy Policy or our data practices, please contact us:</p>
                
                <div class="card">
                    <div class="card-body">
                        <h5 class="card-title">Data Protection Officer (DPO)</h5>
                        <p class="mb-1"><strong>Email:</strong> <a href="mailto:dpo@ai-itinc.com">dpo@ai-itinc.com</a></p>
                        <p class="mb-0"><strong>Company:</strong> AI-IT Inc</p>
                    </div>
                </div>
                
                <p class="mt-3">
                    For general inquiries or support, you may also contact us through your account dashboard or by emailing our support team.
                </p>
            </section>
            
            <section class="mb-5">
                <h2>15. California Privacy Rights (CCPA)</h2>
                <p>
                    If you are a California resident, you have additional rights under the California Consumer Privacy Act (CCPA):
                </p>
                <ul>
                    <li>The right to know what personal information we collect, use, and disclose</li>
                    <li>The right to request deletion of your personal information</li>
                    <li>The right to opt-out of the sale of personal information (we do not sell your personal information)</li>
                    <li>The right to non-discrimination for exercising your privacy rights</li>
                </ul>
                <p>
                    To exercise these rights, please contact our Data Protection Officer at <a href="mailto:dpo@ai-itinc.com">dpo@ai-itinc.com</a>.
                </p>
            </section>
            
            <section class="mb-5">
                <h2>16. European Economic Area (EEA) Privacy Rights (GDPR)</h2>
                <p>
                    If you are located in the European Economic Area, you have specific rights under the General Data Protection Regulation (GDPR). Our Data Protection Officer is available to assist with any GDPR-related inquiries or requests.
                </p>
                <p>
                    <strong>Legal Basis for Processing:</strong> We process your personal data based on:
                </p>
                <ul>
                    <li>Contract performance (providing our services)</li>
                    <li>Legitimate interests (improving services, security, fraud prevention)</li>
                    <li>Your consent (for optional features and marketing communications)</li>
                    <li>Legal obligations (compliance with applicable laws)</li>
                </ul>
                <p>
                    <strong>Supervisory Authority:</strong> If you believe we have not addressed your privacy concerns, you have the right to lodge a complaint with your local data protection supervisory authority.
                </p>
            </section>
            
            <section class="mb-5">
                <h2>17. Third-Party Links</h2>
                <p>
                    Our platform may contain links to third-party websites or services. We are not responsible for the privacy practices of these external sites. We encourage you to review the privacy policies of any third-party sites you visit.
                </p>
            </section>
            
            <hr class="my-4">
            
            <div class="alert alert-info">
                <strong><i class="bi bi-info-circle"></i> Questions or Concerns?</strong>
                <p class="mb-0 mt-2">
                    If you have any questions about this Privacy Policy or our data practices, please contact our Data Protection Officer at <a href="mailto:dpo@ai-itinc.com">dpo@ai-itinc.com</a>.
                </p>
            </div>
            
            <div class="alert alert-secondary mt-3">
                <strong><i class="bi bi-file-earmark-text"></i> Related Documents</strong>
                <p class="mb-0 mt-2">
                    Please also review our <a href="<?= url('terms-of-service.php') ?>">Terms of Service</a> for information about your use of our platform and services.
                </p>
            </div>
        </div>
    </div>
</div>

<footer class="mt-5 py-4 bg-light">
    <div class="container">
        <div class="row">
            <div class="col-md-6">
                <p class="text-muted mb-0">&copy; <?= date('Y') ?> AI-IT Inc. All rights reserved.</p>
            </div>
            <div class="col-md-6 text-end">
                <p class="text-muted mb-0">
                    <a href="<?= url('privacy-policy.php') ?>">Privacy Policy</a> | 
                    <a href="mailto:dpo@ai-itinc.com">Contact DPO</a>
                </p>
            </div>
        </div>
    </div>
</footer>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>

