<?php
/**
 * Partner Registration Page
 */

require_once __DIR__ . '/../includes/functions.php';
require_once __DIR__ . '/../includes/PartnerAuth.php';
require_once __DIR__ . '/../includes/csrf.php';

getBasePath();

$auth = new PartnerAuth();
$db = getDB();
$error = '';
$success = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    requireCSRFToken();
    $partnerName = trim($_POST['partner_name'] ?? '');
    $email = trim($_POST['email'] ?? '');
    $company = trim($_POST['company_name'] ?? '');
    $website = trim($_POST['website'] ?? '');
    $paymentMethod = $_POST['payment_method'] ?? 'paypal';
    $paymentEmail = trim($_POST['payment_email'] ?? '');

    if ($partnerName === '' || !isValidEmail($email)) {
        $error = 'Partner name and a valid email are required';
    } else {
        try {
            // Generate unique partner code
            $partnerCode = $auth->generatePartnerCode($partnerName);

            $stmt = $db->prepare("INSERT INTO affiliate_partners (partner_code, partner_name, contact_email, company_name, website, payment_method, payment_email, status) VALUES (?, ?, ?, ?, ?, ?, ?, 'active')");
            $stmt->execute([$partnerCode, $partnerName, $email, $company, $website, $paymentMethod, $paymentEmail]);

            $success = 'Registration successful! Your partner code is ' . escape($partnerCode) . '. You can now log in.';
            setFlashMessage('success', 'Partner registered. Your code: ' . $partnerCode);
            header('Location: ' . url('partner/login.php'));
            exit;
        } catch (PDOException $e) {
            $error = 'Registration failed: ' . $e->getMessage();
        }
    }
}

$flash = getFlashMessage();
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Partner Registration - Marketing Platform</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.0/font/bootstrap-icons.css">
</head>
<body class="bg-light">
    <div class="container py-5">
        <div class="row justify-content-center">
            <div class="col-md-8 col-lg-6">
                <div class="card shadow">
                    <div class="card-body p-4">
                        <h3 class="mb-3 text-center">Affiliate Partner Registration</h3>
                        <p class="text-muted text-center">Sign up to receive your partner code and start referring clients.</p>

                        <?php if ($error): ?>
                            <div class="alert alert-danger"><?= escape($error) ?></div>
                        <?php endif; ?>

                        <?php if ($flash): ?>
                            <div class="alert alert-<?= escape($flash['type']) ?>"><?= escape($flash['message']) ?></div>
                        <?php endif; ?>

                        <form method="POST">
                            <?= csrfField() ?>
                            <div class="mb-3">
                                <label class="form-label" for="partner_name">Partner Name</label>
                                <input type="text" class="form-control" id="partner_name" name="partner_name" required>
                            </div>
                            <div class="mb-3">
                                <label class="form-label" for="email">Contact Email</label>
                                <input type="email" class="form-control" id="email" name="email" required>
                            </div>
                            <div class="mb-3">
                                <label class="form-label" for="company_name">Company</label>
                                <input type="text" class="form-control" id="company_name" name="company_name">
                            </div>
                            <div class="mb-3">
                                <label class="form-label" for="website">Website</label>
                                <input type="url" class="form-control" id="website" name="website" placeholder="https://...">
                            </div>
                            <div class="mb-3">
                                <label class="form-label">Payout Method</label>
                                <select class="form-select" name="payment_method">
                                    <option value="paypal">PayPal</option>
                                    <option value="bank_transfer">Bank Transfer</option>
                                    <option value="check">Check</option>
                                </select>
                            </div>
                            <div class="mb-3">
                                <label class="form-label" for="payment_email">Payout Email/Details</label>
                                <input type="text" class="form-control" id="payment_email" name="payment_email">
                            </div>
                            <button type="submit" class="btn btn-success w-100">Register</button>
                        </form>

                        <div class="text-center mt-3">
                            <small class="text-muted">Already have a code? <a href="<?= url('partner/login.php') ?>">Login here</a></small>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
 </body>
</html>


