<?php
/**
 * Partner Login Page
 */

require_once __DIR__ . '/../includes/auth.php';
require_once __DIR__ . '/../includes/functions.php';
require_once __DIR__ . '/../includes/PartnerAuth.php';

// Ensure base path is loaded
getBasePath();

$auth = new PartnerAuth();
$error = '';

// Redirect if already logged in
if ($auth->isPartnerLoggedIn()) {
    header('Location: ' . url('partner/dashboard.php'));
    exit;
}

// Handle login form submission
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $partnerCode = trim($_POST['partner_code'] ?? '');
    $email = trim($_POST['email'] ?? '');
    
    if (empty($partnerCode) || empty($email)) {
        $error = 'All fields are required';
    } else {
        if ($auth->login($partnerCode, $email)) {
            header('Location: ' . url('partner/dashboard.php'));
            exit;
        } else {
            $error = 'Invalid partner code or email';
        }
    }
}

$flash = getFlashMessage();
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Partner Login - Marketing Platform</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.0/font/bootstrap-icons.css">
    <style>
        body {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            display: flex;
            align-items: center;
        }
        .login-card {
            background: rgba(255, 255, 255, 0.95);
            backdrop-filter: blur(10px);
            border-radius: 15px;
            box-shadow: 0 15px 35px rgba(0, 0, 0, 0.1);
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-md-6 col-lg-4">
                <div class="card login-card">
                    <div class="card-body p-5">
                        <div class="text-center mb-4">
                            <i class="bi bi-people-fill text-primary" style="font-size: 3rem;"></i>
                            <h3 class="mt-3">Partner Login</h3>
                            <p class="text-muted">Access your affiliate dashboard</p>
                        </div>

                        <?php if ($error): ?>
                            <div class="alert alert-danger" role="alert">
                                <i class="bi bi-exclamation-triangle"></i> <?= escape($error) ?>
                            </div>
                        <?php endif; ?>

                        <?php if ($flash): ?>
                            <div class="alert alert-<?= escape($flash['type']) ?>" role="alert">
                                <?= escape($flash['message']) ?>
                            </div>
                        <?php endif; ?>

                        <form method="POST">
                            <div class="mb-3">
                                <label for="partner_code" class="form-label">Partner Code</label>
                                <div class="input-group">
                                    <span class="input-group-text"><i class="bi bi-tag"></i></span>
                                    <input type="text" class="form-control" id="partner_code" name="partner_code" 
                                           value="<?= escape($_POST['partner_code'] ?? '') ?>" required>
                                </div>
                            </div>

                            <div class="mb-3">
                                <label for="email" class="form-label">Email Address</label>
                                <div class="input-group">
                                    <span class="input-group-text"><i class="bi bi-envelope"></i></span>
                                    <input type="email" class="form-control" id="email" name="email" 
                                           value="<?= escape($_POST['email'] ?? '') ?>" required>
                                </div>
                            </div>

                            <!-- No password required for partner portal; authenticate by partner code + email -->

                            <div class="d-grid">
                                <button type="submit" class="btn btn-primary btn-lg">
                                    <i class="bi bi-box-arrow-in-right"></i> Login
                                </button>
                            </div>
                        </form>

                        <div class="text-center mt-4">
                            <small class="text-muted">
                                Need help? <a href="mailto:support@marketingplatform.com">Contact Support</a>
                            </small>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
