<?php
/**
 * Partner Dashboard
 * Shows affiliate partner statistics and performance
 */

require_once __DIR__ . '/../includes/auth.php';
require_once __DIR__ . '/../includes/functions.php';
require_once __DIR__ . '/../includes/PartnerAuth.php';
require_once __DIR__ . '/../includes/PartnerDashboard.php';

requirePartner();
$pageTitle = 'Partner Dashboard';

$auth = new PartnerAuth();
$partner = $auth->getCurrentPartner();
$dashboard = new PartnerDashboard();

// Get dashboard stats (last 30 days)
$stats = $dashboard->getDashboardStats($partner['id'], 30);
$recentConversions = $dashboard->getRecentConversions($partner['id'], 5);
$payoutHistory = $dashboard->getPayoutHistory($partner['id'], 5);

require_once __DIR__ . '/../includes/header.php';
?>

<div class="row mb-4">
    <div class="col-12">
        <div class="d-flex justify-content-between align-items-center">
            <h1><i class="bi bi-speedometer2"></i> Partner Dashboard</h1>
            <div class="d-flex gap-2">
                <span class="badge bg-info fs-6">Partner Code: <?= escape($partner['partner_code']) ?></span>
                <a href="<?= url('partner/logout.php') ?>" class="btn btn-outline-danger">
                    <i class="bi bi-box-arrow-right"></i> Logout
                </a>
            </div>
        </div>
    </div>
</div>

<!-- Stats Cards -->
<div class="row mb-4">
    <div class="col-md-3">
        <div class="card bg-primary text-white">
            <div class="card-body">
                <div class="d-flex justify-content-between">
                    <div>
                        <h4 class="card-title"><?= number_format($stats['clicks']['total']) ?></h4>
                        <p class="card-text">Total Clicks</p>
                    </div>
                    <div class="align-self-center">
                        <i class="bi bi-mouse fs-1"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <div class="col-md-3">
        <div class="card bg-success text-white">
            <div class="card-body">
                <div class="d-flex justify-content-between">
                    <div>
                        <h4 class="card-title"><?= number_format($stats['conversions']['total']) ?></h4>
                        <p class="card-text">Conversions</p>
                    </div>
                    <div class="align-self-center">
                        <i class="bi bi-graph-up fs-1"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <div class="col-md-3">
        <div class="card bg-warning text-white">
            <div class="card-body">
                <div class="d-flex justify-content-between">
                    <div>
                        <h4 class="card-title"><?= $stats['conversions']['rate'] ?>%</h4>
                        <p class="card-text">Conversion Rate</p>
                    </div>
                    <div class="align-self-center">
                        <i class="bi bi-percent fs-1"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <div class="col-md-3">
        <div class="card bg-info text-white">
            <div class="card-body">
                <div class="d-flex justify-content-between">
                    <div>
                        <h4 class="card-title">$<?= number_format($stats['commissions']['total'], 2) ?></h4>
                        <p class="card-text">Total Commissions</p>
                    </div>
                    <div class="align-self-center">
                        <i class="bi bi-currency-dollar fs-1"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Commission Breakdown -->
<div class="row mb-4">
    <div class="col-md-6">
        <div class="card">
            <div class="card-header">
                <h5 class="mb-0"><i class="bi bi-wallet2"></i> Commission Status</h5>
            </div>
            <div class="card-body">
                <div class="row text-center">
                    <div class="col-6">
                        <h3 class="text-warning">$<?= number_format($stats['commissions']['pending'], 2) ?></h3>
                        <p class="text-muted">Pending</p>
                    </div>
                    <div class="col-6">
                        <h3 class="text-success">$<?= number_format($stats['commissions']['paid'], 2) ?></h3>
                        <p class="text-muted">Paid</p>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <div class="col-md-6">
        <div class="card">
            <div class="card-header">
                <h5 class="mb-0"><i class="bi bi-link-45deg"></i> Your Referral Link</h5>
            </div>
            <div class="card-body">
                <div class="input-group">
                    <input type="text" class="form-control" id="referralLink" 
                           value="<?= url('refer.php?ref=' . $partner['partner_code']) ?>" readonly>
                    <button class="btn btn-outline-secondary" type="button" onclick="copyReferralLink()">
                        <i class="bi bi-copy"></i>
                    </button>
                </div>
                <small class="text-muted">Share this link to earn commissions</small>
            </div>
        </div>
    </div>
</div>

<!-- Recent Activity -->
<div class="row">
    <div class="col-md-6">
        <div class="card">
            <div class="card-header">
                <h5 class="mb-0"><i class="bi bi-clock-history"></i> Recent Conversions</h5>
            </div>
            <div class="card-body">
                <?php if (empty($recentConversions)): ?>
                    <p class="text-muted mb-0">No conversions yet</p>
                <?php else: ?>
                    <div class="list-group list-group-flush">
                        <?php foreach ($recentConversions as $conversion): ?>
                            <div class="list-group-item d-flex justify-content-between align-items-center">
                                <div>
                                    <strong><?= escape($conversion['client_email'] ?? 'Unknown') ?></strong>
                                    <br><small class="text-muted"><?= escape($conversion['business_name'] ?? '') ?></small>
                                </div>
                                <div class="text-end">
                                    <span class="badge bg-success">$<?= number_format($conversion['commission_amount'], 2) ?></span>
                                    <br><small class="text-muted"><?= formatDate($conversion['converted_at']) ?></small>
                                </div>
                            </div>
                        <?php endforeach; ?>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
    
    <div class="col-md-6">
        <div class="card">
            <div class="card-header">
                <h5 class="mb-0"><i class="bi bi-cash-coin"></i> Payout History</h5>
            </div>
            <div class="card-body">
                <?php if (empty($payoutHistory)): ?>
                    <p class="text-muted mb-0">No payouts yet</p>
                <?php else: ?>
                    <div class="list-group list-group-flush">
                        <?php foreach ($payoutHistory as $payout): ?>
                            <div class="list-group-item d-flex justify-content-between align-items-center">
                                <div>
                                    <strong>$<?= number_format($payout['total_commission'], 2) ?></strong>
                                    <br><small class="text-muted"><?= formatDate($payout['payout_period_start']) ?> - <?= formatDate($payout['payout_period_end']) ?></small>
                                </div>
                                <div class="text-end">
                                    <span class="badge bg-<?= $payout['payout_status'] === 'paid' ? 'success' : 'warning' ?>">
                                        <?= escape($payout['payout_status']) ?>
                                    </span>
                                    <br><small class="text-muted"><?= formatDate($payout['created_at']) ?></small>
                                </div>
                            </div>
                        <?php endforeach; ?>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>

<script>
function copyReferralLink() {
    const referralLink = document.getElementById('referralLink');
    referralLink.select();
    referralLink.setSelectionRange(0, 99999); // For mobile devices
    
    try {
        document.execCommand('copy');
        // Show success message
        const button = event.target.closest('button');
        const originalHTML = button.innerHTML;
        button.innerHTML = '<i class="bi bi-check"></i>';
        button.classList.remove('btn-outline-secondary');
        button.classList.add('btn-success');
        
        setTimeout(() => {
            button.innerHTML = originalHTML;
            button.classList.remove('btn-success');
            button.classList.add('btn-outline-secondary');
        }, 2000);
    } catch (err) {
        alert('Failed to copy link');
    }
}
</script>

<?php require_once __DIR__ . '/../includes/footer.php'; ?>
