<?php
/**
 * Client Login Page (clients only)
 */

require_once 'includes/auth.php';
require_once 'includes/functions.php';
require_once 'includes/csrf.php';

// Ensure base path is loaded
getBasePath();

$auth = new Auth();
$error = '';

// Redirect if already logged in
if ($auth->isLoggedIn()) {
    $role = $_SESSION['user_role'];
    header('Location: ' . url($role === 'admin' ? 'admin/dashboard.php' : 'client/dashboard.php'));
    exit;
}

// Handle login form submission
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    requireCSRFToken();
    $email = $_POST['email'] ?? '';
    $password = $_POST['password'] ?? '';
    
    if (!empty($email) && !empty($password)) {
        if ($auth->login($email, $password)) {
            $role = $_SESSION['user_role'] ?? null;
            if ($role === 'client') {
                header('Location: ' . url('client/dashboard.php'));
                exit;
            }
            // Logged in as a non-client; force logout and instruct correct portal
            $auth->logout();
            $error = 'Please use the correct portal: Admins use /admin/login.php, Affiliates use /partner/login.php';
        } else {
            $error = 'Invalid email or password';
        }
    } else {
        $error = 'Please fill in all fields';
    }
}

$flash = getFlashMessage();
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Client Login - Marketing Platform</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.0/font/bootstrap-icons.css">
    <link rel="stylesheet" href="assets/css/style.css">
</head>
<body class="bg-light">
    <div class="container">
        <div class="row justify-content-center align-items-center min-vh-100">
            <div class="col-md-5">
                <div class="card shadow">
                    <div class="card-body p-5">
                        <h2 class="text-center mb-4">Marketing Platform</h2>
                        <h4 class="text-center mb-4 text-muted">Client Login</h4>
                        
                        <div class="text-center mb-3">
                            <a href="<?= url('admin/login.php') ?>" class="btn btn-outline-secondary btn-sm">
                                <i class="bi bi-shield-lock"></i> Admin Login
                            </a>
                        </div>
                        
                        <?php if ($error): ?>
                            <div class="alert alert-danger"><?= escape($error) ?></div>
                        <?php endif; ?>
                        
                        <?php if ($flash): ?>
                            <div class="alert alert-<?= escape($flash['type']) ?>"><?= escape($flash['message']) ?></div>
                        <?php endif; ?>
                        
                        <form method="POST" action="<?= url('login.php') ?>">
                            <?= csrfField() ?>
                            <div class="mb-3">
                                <label for="email" class="form-label">Email Address</label>
                                <input type="email" class="form-control" id="email" name="email" required autofocus>
                            </div>
                            
                            <div class="mb-3">
                                <label for="password" class="form-label">Password</label>
                                <input type="password" class="form-control" id="password" name="password" required>
                            </div>
                            
                            <button type="submit" class="btn btn-primary w-100">Login</button>
                        </form>
                        
                        <div class="text-center mt-3">
                            <small class="text-muted">Admins: <a href="<?= url('admin/login.php') ?>">Admin Login</a> · Affiliates: <a href="<?= url('partner/login.php') ?>">Partner Login</a></small>
                        </div>
                        <div class="text-center mt-2">
                            <small class="text-muted">
                                Don't have an account? <a href="<?= url('register.php') ?>">Create one here</a>
                            </small>
                        </div>
                        <div class="text-center mt-3 pt-3 border-top">
                            <small class="text-muted">
                                <a href="<?= url('privacy-policy.php') ?>" class="text-decoration-none">Privacy Policy</a> | 
                                <a href="<?= url('terms-of-service.php') ?>" class="text-decoration-none">Terms of Service</a>
                            </small>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <footer class="text-center py-3 bg-light mt-5">
        <div class="container">
            <p class="text-muted mb-0 small">
                &copy; <?= date('Y') ?> AI-IT Inc. All rights reserved. | 
                <a href="<?= url('privacy-policy.php') ?>" class="text-decoration-none">Privacy Policy</a> | 
                <a href="<?= url('terms-of-service.php') ?>" class="text-decoration-none">Terms of Service</a> | 
                <a href="mailto:dpo@ai-itinc.com" class="text-decoration-none">Contact DPO</a>
            </p>
        </div>
    </footer>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>

