<?php
/**
 * Landing Page / Redirect
 */

require_once 'includes/functions.php';

// Check if setup needs to be run
require_once __DIR__ . '/setup_check.php';
if (!file_exists(__DIR__ . '/.setup_complete')) {
    header('Location: ' . url('setup_wizard.php'));
    exit;
}

require_once 'includes/auth.php';

try {
    $auth = new Auth();
    
    if ($auth->isLoggedIn()) {
        $role = $_SESSION['user_role'];
        header('Location: ' . url($role === 'admin' ? 'admin/dashboard.php' : 'client/dashboard.php'));
        exit;
    } else {
        header('Location: ' . url('login.php'));
        exit;
    }
} catch (Exception $e) {
    // If database connection fails, redirect to setup
    header('Location: ' . url('setup.php'));
    exit;
}

