<?php
if (!isset($pageTitle)) {
    $pageTitle = 'Dashboard';
}
$user = getCurrentUser();
$subscription = getCurrentSubscription();
$flash = getFlashMessage();

// Check if user wants to show all features in navigation (default: true - show all)
$showAllFeatures = true;
if ($user && isset($user['show_all_features'])) {
    $showAllFeatures = $user['show_all_features'] == 1;
} elseif ($user) {
    // If column doesn't exist or is null, default to true (show all)
    $showAllFeatures = true;
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= escape($pageTitle) ?> - Marketing Platform</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.0/font/bootstrap-icons.css">
    <link rel="stylesheet" href="<?= url('assets/css/style.css') ?>">
    <link rel="stylesheet" href="<?= url('assets/css/custom.css') ?>">
</head>
<body>
    <nav class="navbar navbar-expand-lg navbar-dark bg-primary">
        <div class="container-fluid">
            <a class="navbar-brand" href="<?= url($_SESSION['user_role'] === 'admin' ? 'admin/dashboard.php' : 'client/dashboard.php') ?>">
                <i class="bi bi-graph-up-arrow"></i> Marketing Platform
            </a>
            <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav">
                <span class="navbar-toggler-icon"></span>
            </button>
            <div class="collapse navbar-collapse" id="navbarNav">
                <ul class="navbar-nav ms-auto d-flex align-items-center">
                    <?php if ($_SESSION['user_role'] === 'admin' && isset($_SESSION['viewing_as_client_id'])): ?>
                        <li class="nav-item">
                            <div class="alert alert-warning mb-0 py-1 px-2">
                                <small>
                                    <i class="bi bi-person-check"></i> Viewing as Client | 
                                    <a href="<?= url('admin/stop_viewing_client.php') ?>" class="alert-link">Return to Admin</a>
                                </small>
                            </div>
                        </li>
                    <?php endif; ?>
                    <?php if ($_SESSION['user_role'] === 'partner'): ?>
                        <li class="nav-item">
                            <a class="nav-link" href="<?= url('partner/dashboard.php') ?>"><i class="bi bi-speedometer2"></i> Dashboard</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="<?= url('partner/logout.php') ?>"><i class="bi bi-box-arrow-right"></i> Logout</a>
                        </li>
                    <?php endif; ?>
                    <?php if ($_SESSION['user_role'] === 'client' || (isset($_SESSION['viewing_as_client_id']) && $_SESSION['user_role'] === 'admin')): ?>
                        <!-- Essential Navigation (Always Visible) -->
                        <li class="nav-item">
                            <a class="nav-link" href="<?= url('client/dashboard.php') ?>"><i class="bi bi-speedometer2"></i> Dashboard</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="<?= url('client/campaigns.php') ?>"><i class="bi bi-megaphone"></i> Campaigns</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="<?= url('client/unified_email_sender.php') ?>"><i class="bi bi-envelope-paper-heart"></i> Email Sender</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="<?= url('client/settings.php') ?>"><i class="bi bi-gear"></i> Settings</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="<?= url('client/testing_dashboard.php') ?>"><i class="bi bi-speedometer2"></i> Testing</a>
                        </li>
                        
                        <?php if ($showAllFeatures): ?>
                            <!-- Advanced Features (Visible when show_all_features is enabled) -->
                            <!-- Note: Ad Builder and Email Marketing are now unified in Email Sender -->
                            <li class="nav-item">
                                <a class="nav-link" href="<?= url('client/ab_testing.php') ?>"><i class="bi bi-clipboard-data"></i> A/B Testing</a>
                            </li>
                            <li class="nav-item">
                                <a class="nav-link" href="<?= url('client/webhooks.php') ?>"><i class="bi bi-link-45deg"></i> Webhooks</a>
                            </li>
                            <li class="nav-item">
                                <a class="nav-link" href="<?= url('client/discounts.php') ?>"><i class="bi bi-tag"></i> Discounts</a>
                            </li>
                            <li class="nav-item">
                                <a class="nav-link" href="<?= url('client/direct_mail.php') ?>"><i class="bi bi-envelope-paper"></i> Direct Mail</a>
                            </li>
                            <li class="nav-item">
                                <a class="nav-link" href="<?= url('client/lead_capture.php') ?>"><i class="bi bi-person-plus"></i> Lead Capture</a>
                            </li>
                            <li class="nav-item">
                                <a class="nav-link" href="<?= url('client/analytics.php') ?>"><i class="bi bi-graph-up"></i> Analytics</a>
                            </li>
                            <li class="nav-item">
                                <a class="nav-link" href="<?= url('client/reports.php') ?>"><i class="bi bi-file-earmark-text"></i> Reports</a>
                            </li>
                            <li class="nav-item">
                                <a class="nav-link" href="<?= url('client/tracking_code.php') ?>"><i class="bi bi-code-square"></i> Tracking Code</a>
                            </li>
                        <?php endif; ?>
                    <?php elseif ($_SESSION['user_role'] === 'admin'): ?>
                        <li class="nav-item">
                            <a class="nav-link" href="<?= url('admin/dashboard.php') ?>"><i class="bi bi-speedometer2"></i> Dashboard</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="<?= url('admin/clients.php') ?>"><i class="bi bi-people"></i> Clients</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="<?= url('admin/subscriptions.php') ?>"><i class="bi bi-credit-card"></i> Subscriptions</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="<?= url('admin/campaigns.php') ?>"><i class="bi bi-megaphone"></i> Campaigns</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="<?= url('admin/activity_log.php') ?>"><i class="bi bi-clock-history"></i> Activity Log</a>
                        </li>
                    <?php endif; ?>
                    <li class="nav-item dropdown">
                        <a class="nav-link dropdown-toggle" href="#" id="navbarDropdown" role="button" data-bs-toggle="dropdown">
                            <i class="bi bi-person-circle"></i> <?= escape($_SESSION['business_name'] ?? $_SESSION['user_email']) ?>
                            <?php if ($subscription): ?>
                                <span class="badge bg-success ms-1"><?= escape($subscription['tier_name']) ?></span>
                            <?php endif; ?>
                        </a>
                        <ul class="dropdown-menu dropdown-menu-end">
                            <li><a class="dropdown-item" href="<?= url('logout.php') ?>"><i class="bi bi-box-arrow-right"></i> Logout</a></li>
                        </ul>
                    </li>
                </ul>
            </div>
        </div>
    </nav>

    <div class="container-fluid mt-4">
        <?php if ($flash): ?>
            <div class="alert alert-<?= escape($flash['type']) ?> alert-dismissible fade show" role="alert">
                <?= escape($flash['message']) ?>
                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            </div>
        <?php endif; ?>

