# User Guide - Marketing Platform

## Getting Started

### For Administrators

#### Login
1. Navigate to `http://localhost:8000/login.php`
2. Enter your admin credentials:
   - Email: `admin@marketingplatform.com`
   - Password: `admin123` (change after first login)

#### Managing Clients
1. Go to **Clients** from the admin menu
2. **Add New Client**: Click "Add New Client" button
   - Fill in required fields (email, password, business name, contact name)
   - Optional: Add address, phone, city, state, zip code
   - Click "Create Client"

3. **Search Clients**: Use the search box to find clients by:
   - Business name
   - Email address
   - Contact name

4. **Filter Clients**: 
   - Filter by Status: Active, Inactive, Suspended
   - Filter by Subscription: With/Without active subscription

5. **Edit Client**: Click the edit icon (pencil) next to a client
   - Update client information
   - Change password (optional)
   - Update status

6. **Deactivate Client**: Click the delete icon (trash)
   - Confirms before deactivating
   - Client status set to 'inactive'

7. **Manage Subscription**: Click "Manage Subscription" or subscription icon
   - Create new subscription
   - Update subscription tier
   - Cancel subscription
   - View transaction history

#### Managing Subscriptions
1. Go to **Subscriptions** from the admin menu
2. View all active subscriptions
3. Manage individual subscriptions from client details

#### Dashboard
- View key metrics: Total clients, active subscriptions, monthly revenue, active campaigns
- See subscriptions by tier breakdown
- View recent clients

### For Clients

#### Login
1. Navigate to `http://localhost:8000/login.php`
2. Enter your client credentials (provided by admin)

#### Dashboard
- View your subscription tier and auth
- See campaign performance metrics
- View recent activity

#### Campaigns
- Create and manage marketing campaigns
- Track Google Ads and Facebook Ads performance
- View campaign analytics

#### Discounts
- Generate discount codes
- Set discount rules and limits
- Track code usage

#### Direct Mail
- Create direct mail campaigns
- Upload designs
- Track mailing status

#### Analytics
- View visitor metrics
- Track conversions
- Analyze UTM parameters

## Features by Subscription Tier

### Starter Plan ($299/month)
- Google Ads: $200/month budget
- Facebook Ads: $150/month budget  
- Email: 1,000 contacts, 4 campaigns/month
- Discount codes: 5/month
- Direct mail: 500 postcards quarterly

### Professional Plan ($599/month)
- Google Ads: $500/month budget
- Facebook Ads: $400/month budget
- Email: 5,000 contacts, unlimited campaigns
- Discount codes: Unlimited
- Direct mail: 1,500 postcards monthly
- A/B testing and optimization

### Enterprise Plan ($999/month)
- Google Ads: $1,200/month budget
- Facebook Ads: $800/month budget
- Email: Unlimited contacts and campaigns
- Discount codes: Unlimited with advanced rules
- Direct mail: 5,000 postcards monthly
- API access, advanced analytics, custom integrations

## Best Practices

### Security
- Always use strong passwords (8+ characters)
- Log out when finished
- Don't share login credentials
- Change default passwords immediately

### Campaign Management
- Set realistic budgets
- Monitor performance regularly
- Use A/B testing for optimization
- Track ROI on all campaigns

### Discount Codes
- Set expiration dates
- Monitor usage limits
- Track redemption rates
- Use clear, memorable codes

## Troubleshooting

### Login Issues
- Verify email address is correct
- Check password (case-sensitive)
- Ensure account is active
- Contact admin if locked out

### Performance Issues
- Check subscription tier limits
- Verify API credentials are configured
- Review campaign budgets
- Check database connectivity

## Support

For technical support, contact your administrator or refer to the developer documentation.

