# System Architecture & Domain Setup

## Overview

The Marketing Platform is a multi-domain system connecting affiliate marketing, lead generation, and ad serving across different domains for optimal performance and tracking.

## Domain Structure

### 1. Main Platform (affiliate-iti.com)
**Purpose:** Main CRM and campaign management platform  
**Path:** `/mk/market/`  
**Features:**
- Client registration and login
- CRM management (customer data)
- Campaign creation and management
- Email service (uses CRM customer data)
- Affiliate partner registration
- Analytics and reporting

**Key URLs:**
- `https://affiliate-iti.com/mk/market/` - Main platform
- `https://affiliate-iti.com/mk/market/client/` - Client dashboard
- `https://affiliate-iti.com/mk/market/partner/` - Affiliate partner portal

### 2. AcceleratedAdz (ai-itinc.com/acceleratedadz)
**Purpose:** Public-facing ad display and serving  
**Features:**
- Display ads created via API from main platform
- Track impressions and clicks
- Redirect to AcceleratedLeadz or destination URLs
- Support for Image, Video, HTML5, Text ad types

**Key URLs:**
- `https://ai-itinc.com/acceleratedadz?id=123` - Display specific ad
- `https://ai-itinc.com/acceleratedadz?campaign=5` - Display random ad from campaign
- `https://ai-itinc.com/acceleratedadz?click=123&redirect=https://example.com` - Click tracking

**API Integration:**
- Ads are created via API from `affiliate-iti.com`
- POST to `https://affiliate-iti.com/mk/market/api/acceleratedadz.php`

### 3. AcceleratedLeadz (ai-itinc.com/acceleratedleadz)
**Purpose:** Lead generation and capture from ad traffic  
**Features:**
- Public lead capture forms
- Affiliate tracking via `?ref=PARTNER_CODE`
- Automatic lead attribution
- CRM integration
- Email queue for automated follow-up

**Key URLs:**
- `https://ai-itinc.com/acceleratedleadz?user=123` - Lead form for specific client
- `https://ai-itinc.com/acceleratedleadz?ref=PARTNER_CODE` - Affiliate-tracked lead form
- `https://ai-itinc.com/acceleratedleadz?campaign=5&user=123` - Campaign-specific form

## Data Flow

### Ad Creation Flow:
```
1. Client logs into affiliate-iti.com/mk/market/client/
2. Creates AcceleratedAdz campaign
3. API posts ad to ai-itinc.com domain
4. Ad is available at ai-itinc.com/acceleratedadz?id=123
```

### Traffic & Lead Flow:
```
1. User clicks ad on ai-itinc.com/acceleratedadz?id=123
2. Ad click tracked in database
3. User redirected to ai-itinc.com/acceleratedleadz?ref=PARTNER_CODE
4. Lead form captures information
5. Lead stored in:
   - email_subscribers (CRM)
   - client_leads (with affiliate attribution)
6. Email queued if campaign specified
7. Lead appears in affiliate-iti.com CRM dashboard
```

### Email Service Flow:
```
1. CRM stores customer data (email_subscribers table)
2. Email campaigns created on affiliate-iti.com
3. Emails sent using CRM customer data
4. IMAP integration with roundbox processes incoming emails
5. AcceleratedLeadz worker sends 1 email per minute from queue
```

### Affiliate Flow:
```
1. Affiliate registers at affiliate-iti.com/mk/market/client/
   (or affiliate-iti.com/mk/market/partner/register.php)
2. Gets unique partner code
3. Creates ads that link to:
   https://ai-itinc.com/acceleratedleadz?ref=PARTNER_CODE
4. Traffic clicks ads → goes to AcceleratedLeadz
5. Leads tracked and attributed to affiliate
6. Commissions calculated and paid
```

## Database Connections

All systems share the same database hosted on `affiliate-iti.com`:
- `acceleratedadz_campaigns`, `acceleratedadz_ads`, `acceleratedadz_performance`
- `accelerated_leadz_campaigns`, `accelerated_leadz_email_queue`
- `email_subscribers` (CRM)
- `client_leads` (with affiliate tracking)
- `affiliate_partners`, `affiliate_clicks`, `affiliate_conversions`

## API Endpoints

### AcceleratedAdz API
**Base URL:** `https://affiliate-iti.com/mk/market/api/acceleratedadz.php`

**Actions:**
- `create_campaign` - Create new ad campaign
- `create_ad` - Create new ad
- `get_campaigns` - List campaigns
- `track_click` - Track ad clicks (public)
- `get_performance` - Get campaign performance

### AcceleratedLeadz API
**Base URL:** `https://affiliate-iti.com/mk/market/api/acceleratedleadz.php`

**Actions:**
- `process_imap` - Process IMAP emails from roundbox
- `queue_email` - Queue email to CRM customer
- `create_campaign` - Create email automation campaign
- `get_campaigns` - List campaigns
- `get_queue_stats` - Get email queue statistics

## Cross-Domain Configuration

### CORS Headers
Both APIs include CORS headers for `ai-itinc.com`:
```php
header('Access-Control-Allow-Origin: https://ai-itinc.com');
```

### Base Path Configuration
- Main platform uses: `affiliate-iti.com`
- Ad/Lead pages use: `ai-itinc.com`
- APIs can be called from both domains

## Email Service Integration

### IMAP (Roundbox)
- Configured in `config/email_config.php`
- Processes emails via `api/acceleratedleadz.php?action=process_imap`
- Stores in `accelerated_leadz_imap_emails` table

### Email Queue Worker
- Runs every minute via cron
- Sends 1 email per minute (Mailchimp-style)
- Worker: `api/acceleratedleadz_worker.php`

### CRM Data Usage
- Email service reads from `email_subscribers` table
- Customer data from CRM used for personalization
- Email content supports: `{{first_name}}`, `{{last_name}}`, `{{email}}`

## Affiliate Registration

### Client Registration (Affiliates)
**URL:** `https://affiliate-iti.com/mk/market/client/` or `register.php`

Clients can:
1. Register as affiliate marketers
2. Get access to AcceleratedLeadz lead generation
3. Create ads that drive traffic to their lead forms
4. Track leads and conversions

### Partner Registration
**URL:** `https://affiliate-iti.com/mk/market/partner/register.php`

Partners can:
1. Register for affiliate program
2. Get unique partner code
3. Generate referral links
4. Track commissions

## Security Considerations

1. **Cross-Domain Authentication:**
   - APIs use session-based auth for management
   - Public endpoints (ads, lead forms) require no auth
   - Affiliate tracking via secure session cookies

2. **Data Protection:**
   - All personal data encrypted at rest
   - HTTPS required for all domains
   - GDPR compliance via privacy policy

3. **API Security:**
   - CSRF protection on all forms
   - Rate limiting recommended for production
   - Input validation and sanitization

## Deployment Notes

### Required Domains:
1. `affiliate-iti.com` - Main platform
2. `ai-itinc.com` - Ad serving & lead capture

### Required DNS:
- Point both domains to same server (or configure load balancer)
- Ensure SSL certificates for both domains

### Database:
- Single database for all systems
- Shared tables for cross-domain functionality
- Backup strategy should include all tables

## Support & Documentation

- **Setup Guide:** See `ACCELERATEDLEADZ_SETUP.md`
- **API Documentation:** See `API_DOCUMENTATION.md`
- **Public Endpoints:** See `PUBLIC_ENDPOINTS.md`
- **Main README:** See `README.md`

For questions: support@ai-itinc.com

