# Public Endpoints Documentation

## AcceleratedAdz - Ad Campaign Endpoints

### Display Ad
**URL:** `https://ai-itinc.com/acceleratedadz?id=123`

**Parameters:**
- `id` (required): Ad ID to display
- `campaign` (optional): Campaign ID - displays random active ad from campaign if no `id` provided

**Features:**
- Automatically tracks impressions
- Beautiful responsive ad display
- Supports Image, Video, HTML5, Text ad types
- Click tracking with redirect to destination URL
- Mobile-friendly design

**Example:**
```
https://ai-itinc.com/acceleratedadz?id=123
https://ai-itinc.com/acceleratedadz?campaign=5
```

### Ad Click Tracking
**URL:** `https://ai-itinc.com/acceleratedadz?click=123&redirect=https://example.com`

**Parameters:**
- `click` (required): Ad ID that was clicked
- `redirect` (required): Destination URL to redirect to after tracking

**Usage:**
This endpoint is used internally by the ad display page when users click on ads. It tracks the click and redirects to the destination URL.

---

## AcceleratedLeadz - Lead Capture Form Endpoints

### Lead Capture Form
**URL:** `https://ai-itinc.com/acceleratedleadz?id=123`

**Parameters:**
- `id` (optional): Form ID for customized forms (future feature)
- `campaign` (optional): Campaign ID - adds lead to email queue if provided
- `user` (optional): User ID for CRM assignment - if provided, lead is assigned to that user's CRM

**Features:**
- Beautiful, responsive lead capture form
- No authentication required (public)
- Automatically adds leads to CRM (`email_subscribers` table)
- Optionally creates `client_leads` entry if `user` parameter provided
- Can automatically queue welcome emails if `campaign` parameter provided
- Mobile-friendly design
- Bootstrap 5 styling

**Form Fields:**
- First Name
- Last Name
- Email Address (required)
- Phone Number
- Company Name
- Additional Information (notes)

**Example URLs:**
```
https://ai-itinc.com/acceleratedleadz?id=1
https://ai-itinc.com/acceleratedleadz?campaign=5&user=123
https://ai-itinc.com/acceleratedleadz?user=123
```

**Success Response:**
After successful submission, displays a success message:
- "Thank You! We've received your information and will be in touch soon."

**Integration:**
Leads are automatically:
1. Added to `email_subscribers` table (CRM)
2. Added to `client_leads` table (if `user` parameter provided)
3. Queued for email automation (if `campaign` parameter provided)

---

## Embedding Options

### Embed Ad in Website
```html
<iframe src="https://ai-itinc.com/acceleratedadz?id=123" 
        width="600" 
        height="400" 
        frameborder="0"
        scrolling="no"></iframe>
```

### Embed Lead Form in Website
```html
<iframe src="https://ai-itinc.com/acceleratedleadz?user=123&campaign=5" 
        width="600" 
        height="800" 
        frameborder="0"
        scrolling="no"></iframe>
```

### Direct Link
```html
<a href="https://ai-itinc.com/acceleratedadz?id=123">View Our Ad</a>
<a href="https://ai-itinc.com/acceleratedleadz?user=123">Sign Up Now</a>
```

---

## API Endpoints

### Track Ad Click
**Endpoint:** `POST /api/acceleratedadz.php`

**Parameters:**
```json
{
  "action": "track_click",
  "ad_id": 123
}
```

**Response:**
```json
{
  "success": true,
  "clicked": 123
}
```

---

## Tracking & Analytics

### Ad Impressions
- Automatically tracked when ad page is loaded
- Stored in `acceleratedadz_performance` table
- Updates daily performance metrics

### Ad Clicks
- Tracked when user clicks on ad CTA button
- Uses `navigator.sendBeacon()` for reliable tracking
- Fallback to `fetch()` API
- Stored in `acceleratedadz_performance` table

### Lead Form Submissions
- Tracked via form submission
- Stored in `email_subscribers` and `client_leads` tables
- Optionally triggers email automation

---

## Customization

### Ad Display Customization
Ads support multiple types:
- **Image Ads**: Display image with headline, description, and CTA
- **Video Ads**: HTML5 video player with overlay content
- **HTML5 Ads**: Custom HTML/CSS/JS creative
- **Text Ads**: Text-only advertisements

### Form Customization
Forms can be customized via URL parameters:
- Different styling per user
- Custom branding per campaign
- Pre-filled fields (future feature)

---

## Security Notes

1. **Public Endpoints**: Both endpoints are public and require no authentication
2. **Input Validation**: All user inputs are sanitized and validated
3. **CSRF Protection**: Form submissions include CSRF protection
4. **Rate Limiting**: Consider implementing rate limiting for production
5. **HTTPS**: Always use HTTPS in production

---

## Error Handling

### Ad Not Found (404)
If ad ID or campaign ID is invalid:
- Returns 404 HTTP status
- Displays "Ad not found" message

### Form Submission Errors
- Email validation errors
- Database errors (logged, user sees friendly message)
- Missing required fields

---

## Support

For questions or issues:
- Email: support@ai-itinc.com
- Documentation: See `ACCELERATEDLEADZ_SETUP.md` and `ACCELERATEDADZ_SETUP.md`

