# Local Development Setup Guide

This guide helps you set up the marketing platform locally before deploying to production where `ai-itinc.com` is the main hosting site.

## Local Domain Configuration

### Option 1: Using Virtual Hosts (Recommended)

#### Windows (XAMPP)

1. **Edit hosts file:**
   ```
   C:\Windows\System32\drivers\etc\hosts
   ```
   
   Add these lines:
   ```
   127.0.0.1  ai-itinc.local
   127.0.0.1  affiliate-it.local
   ```

2. **Configure Apache Virtual Hosts:**
   
   Edit `C:\xampp\apache\conf\extra\httpd-vhosts.conf`
   
   Add:
   ```apache
   <VirtualHost *:80>
       ServerName ai-itinc.local
       DocumentRoot "C:/xampp/htdocs/1.2/mk/market"
       <Directory "C:/xampp/htdocs/1.2/mk/market">
           Options Indexes FollowSymLinks
           AllowOverride All
           Require all granted
       </Directory>
   </VirtualHost>
   
   <VirtualHost *:80>
       ServerName affiliate-it.local
       DocumentRoot "C:/xampp/htdocs/1.2/mk/market"
       <Directory "C:/xampp/htdocs/1.2/mk/market">
           Options Indexes FollowSymLinks
           AllowOverride All
           Require all granted
       </Directory>
   </VirtualHost>
   ```

3. **Restart Apache**

#### Linux/Mac

1. **Edit hosts file:**
   ```bash
   sudo nano /etc/hosts
   ```
   
   Add:
   ```
   127.0.0.1  ai-itinc.local
   127.0.0.1  affiliate-it.local
   ```

2. **Configure Apache Virtual Hosts:**
   
   Create `/etc/apache2/sites-available/ai-itinc.local.conf`:
   ```apache
   <VirtualHost *:80>
       ServerName ai-itinc.local
       DocumentRoot "/path/to/mk/market"
       <Directory "/path/to/mk/market">
           Options Indexes FollowSymLinks
           AllowOverride All
           Require all granted
       </Directory>
   </VirtualHost>
   
   <VirtualHost *:80>
       ServerName affiliate-it.local
       DocumentRoot "/path/to/mk/market"
       <Directory "/path/to/mk/market">
           Options Indexes FollowSymLinks
           AllowOverride All
           Require all granted
       </Directory>
   </VirtualHost>
   ```

3. **Enable and restart:**
   ```bash
   sudo a2ensite ai-itinc.local.conf
   sudo systemctl restart apache2
   ```

### Option 2: Using Ports (Quick Setup)

Access via:
- Main: `http://localhost/mk/market/`
- Ad: `http://localhost/acceleratedadz.php`
- Lead: `http://localhost/acceleratedleadz.php`

Update `config/domain_config.php` to use `localhost` if needed.

## Database Setup

1. **Create database:**
   ```sql
   CREATE DATABASE mindsybq_market CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
   ```

2. **Import schema:**
   ```bash
   mysql -u root -p mindsybq_market < mk/market/database/schema_main.sql
   ```

3. **Configure database connection:**
   
   Edit `mk/market/config/database.php`:
   ```php
   define('DB_HOST', 'localhost');
   define('DB_NAME', 'mindsybq_market');
   define('DB_USER', 'root');
   define('DB_PASS', '');
   ```

## Local Testing URLs

### Main Platform
- **Login:** `http://ai-itinc.local/mk/market/login.php`
- **Register:** `http://ai-itinc.local/mk/market/register.php`
- **Client Dashboard:** `http://ai-itinc.local/mk/market/client/dashboard.php`
- **Admin:** `http://ai-itinc.local/mk/market/admin/dashboard.php`

### AcceleratedAdz
- **Display Ad:** `http://ai-itinc.local/acceleratedadz.php?id=1`
- **Campaign Ad:** `http://ai-itinc.local/acceleratedadz.php?campaign=1`

### AcceleratedLeadz
- **Lead Form:** `http://ai-itinc.local/acceleratedleadz.php`
- **With Affiliate:** `http://ai-itinc.local/acceleratedleadz.php?ref=TEST123`
- **With User:** `http://ai-itinc.local/acceleratedleadz.php?user=1`

### API Endpoints
- **AcceleratedAdz API:** `http://ai-itinc.local/mk/market/api/acceleratedadz.php`
- **AcceleratedLeadz API:** `http://ai-itinc.local/mk/market/api/acceleratedleadz.php`

## Testing Local Connections

1. **Test Ad Display:**
   ```
   Visit: http://ai-itinc.local/acceleratedadz.php?id=1
   ```

2. **Test Lead Form:**
   ```
   Visit: http://ai-itinc.local/acceleratedleadz.php?ref=TEST123
   Submit form and check database
   ```

3. **Test CRM Integration:**
   ```
   1. Submit lead form
   2. Login: http://ai-itinc.local/mk/market/client/crm.php
   3. Verify lead appears with affiliate attribution
   ```

## Configuration Files

### Domain Configuration
`config/domain_config.php` - Auto-detects local vs production

### Database
`config/database.php` - Database connection settings

### Email (IMAP)
`config/email_config.php` - Email service configuration

## Production Deployment

When deploying to production where `ai-itinc.com` is the main host:

### 1. Domain Setup
- Point `ai-itinc.com` to your server
- Point `affiliate-it.com` to same server (or configure DNS alias)
- Both domains should point to `/mk/market/` directory

### 2. Apache/Nginx Configuration

**Apache Virtual Host:**
```apache
<VirtualHost *:80>
    ServerName ai-itinc.com
    ServerAlias affiliate-it.com
    DocumentRoot "/var/www/mk/market"
    # ... SSL configuration ...
</VirtualHost>
```

**Nginx:**
```nginx
server {
    server_name ai-itinc.com affiliate-it.com;
    root /var/www/mk/market;
    # ... SSL configuration ...
}
```

### 3. Update Configuration

The system will auto-detect production environment based on domain name. No changes needed to `domain_config.php` - it automatically switches based on `HTTP_HOST`.

### 4. SSL Certificates

Ensure SSL certificates are configured for both domains:
- `ai-itinc.com`
- `affiliate-it.com`

## Troubleshooting

### Local domains not working
- Check hosts file has correct entries
- Verify virtual hosts are configured
- Restart Apache/web server
- Check firewall isn't blocking ports

### Database connection issues
- Verify MySQL is running
- Check credentials in `config/database.php`
- Ensure database exists and schema is imported

### API CORS errors
- Verify `domain_config.php` is loaded
- Check CORS headers in API files
- For local, may need to allow `localhost` in CORS

## Next Steps

After local setup:
1. Test all features locally
2. Create test ads and campaigns
3. Test affiliate tracking
4. Test email queue worker
5. Deploy to production following production guide

## Support

For issues:
- Check error logs: `error_log` file in project root
- Review database connection settings
- Verify file permissions

