# Installation Guide

## Quick Start

1. **Import Database Schema**
   ```bash
   mysql -u root -p your_database < database/schema.sql
   ```

2. **Configure Database**
   - Edit `config/database.php`
   - Update DB_HOST, DB_NAME, DB_USER, DB_PASS

3. **Configure API Keys** (Optional)
   - Edit `config/google_ads_config.php`
   - Edit `config/facebook_config.php`
   - Edit `config/email_config.php`

4. **Set File Permissions**
   ```bash
   chmod 755 -R .
   chmod 644 config/*.php
   ```

5. **Access Platform**
   - Default admin: `admin@marketingplatform.com` / `admin123`
   - Login: `http://yourdomain.com/login.php`

## Detailed Installation

### Step 1: Server Requirements

- PHP 8.1 or higher
- MySQL 8.0 or higher
- Apache or Nginx web server
- PHP extensions: mysqli, curl, json, mbstring, openssl

### Step 2: Database Setup

1. Create a MySQL database:
   ```sql
   CREATE DATABASE marketing_platform CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
   ```

2. Import the schema:
   ```bash
   mysql -u your_user -p marketing_platform < database/schema.sql
   ```

   Or use phpMyAdmin:
   - Login to phpMyAdmin
   - Select your database
   - Click "Import"
   - Choose `database/schema.sql`
   - Click "Go"

### Step 3: Configuration

Edit `config/database.php`:
```php
define('DB_HOST', 'localhost');
define('DB_NAME', 'marketing_platform');
define('DB_USER', 'your_username');
define('DB_PASS', 'your_password');
```

### Step 4: API Integration Setup (Optional)

#### Google Ads API:
1. Create a Google Ads account and API credentials
2. Edit `config/google_ads_config.php`
3. Install library: `composer require googleads/google-ads-php`

#### Facebook Marketing API:
1. Create Facebook App and get API credentials
2. Edit `config/facebook_config.php`
3. Install library: `composer require facebook/php-business-sdk`

#### Email Service (SendGrid):
1. Sign up for SendGrid account
2. Generate API key
3. Edit `config/email_config.php`
4. Install library: `composer require sendgrid/sendgrid`

### Step 5: Security

1. **Change Default Admin Password**
   - Login as admin
   - Go to profile settings (when implemented)
   - Change password immediately

2. **Enable HTTPS**
   - Uncomment HTTPS redirect in `.htaccess`
   - Install SSL certificate

3. **Protect Config Files**
   - Ensure `.htaccess` is working
   - Keep config files outside web root if possible

### Step 6: Testing

1. Login as admin
2. Create a test client account
3. Create a test subscription
4. Test client login
5. Verify dashboard loads correctly

## Troubleshooting

### Database Connection Error
- Verify database credentials in `config/database.php`
- Check MySQL service is running
- Verify database exists

### Session Errors
- Check PHP session directory is writable
- Verify session.save_path in php.ini

### Permission Errors
- Check file permissions: `chmod 755` for directories, `644` for files
- Verify web server user has read access

### API Integration Not Working
- Verify API credentials are correct
- Check if required libraries are installed
- Review error logs for specific messages

## Next Steps

After installation:
1. Create your first client account
2. Assign a subscription tier
3. Configure API integrations
4. Set up tracking on client websites
5. Create your first marketing campaign

