# Domain Connections & Integration Guide

## Overview

This document explains how to connect the three main components of the marketing platform across different domains.

## Domain Configuration

### 1. Main Platform (affiliate-iti.com)
**Location:** `/mk/market/`  
**Purpose:** CRM, campaign management, affiliate registration

**Key Endpoints:**
- Client Dashboard: `https://affiliate-iti.com/mk/market/client/`
- Affiliate Registration: `https://affiliate-iti.com/mk/market/client/` (clients can become affiliates)
- Partner Portal: `https://affiliate-iti.com/mk/market/partner/`
- API Base: `https://affiliate-iti.com/mk/market/api/`

### 2. AcceleratedAdz (ai-itinc.com/acceleratedadz)
**Location:** Root `/acceleratedadz.php`  
**Purpose:** Public ad serving

**URL Pattern:**
- Display Ad: `https://ai-itinc.com/acceleratedadz?id=123`
- Campaign Ad: `https://ai-itinc.com/acceleratedadz?campaign=5`

**Integration:**
- Ads created via API from main platform
- Destination URLs point to AcceleratedLeadz with affiliate codes
- Example: `https://ai-itinc.com/acceleratedleadz?ref=PARTNER_CODE&campaign=5`

### 3. AcceleratedLeadz (ai-itinc.com/acceleratedleadz)
**Location:** Root `/acceleratedleadz.php`  
**Purpose:** Lead capture from ad traffic

**URL Pattern:**
- Client Form: `https://ai-itinc.com/acceleratedleadz?user=123`
- Affiliate Form: `https://ai-itinc.com/acceleratedleadz?ref=PARTNER_CODE`
- Campaign Form: `https://ai-itinc.com/acceleratedleadz?campaign=5&user=123&ref=CODE`

**Integration:**
- Receives traffic from AcceleratedAdz
- Tracks affiliate clicks automatically
- Stores leads in CRM (affiliate-iti.com database)
- Queues emails for automation

## Complete Traffic Flow

### Example: Affiliate Creates Ad Campaign

1. **Affiliate Registers:**
   ```
   https://affiliate-iti.com/mk/market/client/
   → Creates account
   → Gets access to AcceleratedAdz and AcceleratedLeadz
   ```

2. **Affiliate Creates Ad:**
   ```
   POST https://affiliate-iti.com/mk/market/api/acceleratedadz.php
   {
     "action": "create_ad",
     "destination_url": "https://ai-itinc.com/acceleratedleadz?ref=PARTNER_CODE&campaign=5"
   }
   ```

3. **Ad Published:**
   ```
   https://ai-itinc.com/acceleratedadz?id=123
   ```

4. **User Clicks Ad:**
   ```
   Click tracked → Redirect to:
   https://ai-itinc.com/acceleratedleadz?ref=PARTNER_CODE&campaign=5
   ```

5. **Lead Captured:**
   ```
   Form submission → Stored in:
   - email_subscribers (CRM)
   - client_leads (with affiliate attribution)
   → Email queued if campaign specified
   ```

6. **Lead Appears in CRM:**
   ```
   https://affiliate-iti.com/mk/market/client/crm.php
   → Lead visible with affiliate tracking
   ```

## API Integration

### Creating Ads from Main Platform

```php
// From affiliate-iti.com
$adData = [
    'action' => 'create_ad',
    'ad_group_id' => 1,
    'campaign_id' => 1,
    'ad_name' => 'My Ad',
    'headline' => 'Get Started Today',
    'description' => 'Join thousands of customers',
    'destination_url' => 'https://ai-itinc.com/acceleratedleadz?ref=PARTNER_CODE',
    'display_url' => 'ai-itinc.com',
    'image_url' => 'https://example.com/ad.jpg',
    'call_to_action' => 'Learn More'
];

// POST to local API (same domain)
fetch('https://affiliate-iti.com/mk/market/api/acceleratedadz.php', {
    method: 'POST',
    body: formData
});
```

### Tracking Ad Performance

```javascript
// Ad click automatically tracked
// View in: https://affiliate-iti.com/mk/market/client/acceleratedadz.php
```

### Lead Tracking

```javascript
// Lead automatically tracked when form submitted
// View in: https://affiliate-iti.com/mk/market/client/crm.php
// Affiliate attribution visible in leads
```

## Database Sharing

All three domains share the same database:

**Tables Used:**
- `acceleratedadz_campaigns`, `acceleratedadz_ads`, `acceleratedadz_performance`
- `accelerated_leadz_campaigns`, `accelerated_leadz_email_queue`
- `email_subscribers` (CRM)
- `client_leads` (with affiliate tracking)
- `affiliate_partners`, `affiliate_clicks`, `affiliate_conversions`
- `users`, `campaigns`, `subscriptions`

## Email Service Connection

### CRM → Email Service
```
1. Customer data stored in email_subscribers (CRM)
2. Email campaigns created on main platform
3. AcceleratedLeadz worker sends emails at 1 per minute
4. Uses CRM customer data for personalization
```

### IMAP Integration (Roundbox)
```
1. Configured in config/email_config.php
2. Process via: api/acceleratedleadz.php?action=process_imap
3. Stores in: accelerated_leadz_imap_emails
4. Can trigger email automation campaigns
```

## Affiliate Registration Path

### Option 1: Client Registration (Affiliates)
```
https://affiliate-iti.com/mk/market/register.php
→ Creates user account
→ Can access AcceleratedAdz and AcceleratedLeadz
→ Can generate affiliate links
```

### Option 2: Partner Portal
```
https://affiliate-iti.com/mk/market/partner/register.php
→ Creates affiliate partner account
→ Gets partner code
→ Can use in AcceleratedLeadz URLs: ?ref=PARTNER_CODE
```

## Cross-Domain Setup

### Same Server Configuration
If all domains point to same server:
1. Configure virtual hosts for each domain
2. Point document roots to same `/mk/market/` directory
3. Update `base_path.php` to handle domain detection
4. CORS headers already configured in APIs

### Different Servers Configuration
If domains on different servers:
1. Share database (configure remote MySQL access)
2. Update API CORS headers:
   ```php
   header('Access-Control-Allow-Origin: https://ai-itinc.com');
   ```
3. Use API calls between servers (with authentication)

## Testing Connections

### Test Ad Display:
```
Visit: https://ai-itinc.com/acceleratedadz?id=1
Should: Display ad with tracking enabled
```

### Test Lead Capture:
```
Visit: https://ai-itinc.com/acceleratedleadz?ref=TEST_CODE
Should: Show form, track affiliate click, store lead
```

### Test CRM Integration:
```
1. Submit lead form on ai-itinc.com
2. Check: https://affiliate-iti.com/mk/market/client/crm.php
Should: See lead with affiliate attribution
```

## Troubleshooting

### Ads Not Showing
- Check ad status is 'active'
- Verify database connection
- Check API authentication

### Leads Not Capturing
- Verify affiliate code in URL
- Check session handling
- Verify database permissions

### Email Service Not Working
- Check IMAP configuration
- Verify cron job running (acceleratedleadz_worker.php)
- Check email_subscribers table has data

## Support

For integration questions:
- Email: support@ai-itinc.com
- Docs: See `SYSTEM_ARCHITECTURE.md`

