# API Documentation - Marketing Platform

## Overview

The Marketing Platform provides RESTful API endpoints for managing campaigns, subscriptions, and user data.

## Base URL

```
http://localhost:8000/api/
```

## Authentication

All API endpoints require authentication. Currently using session-based authentication.

**Note:** API token authentication is planned for version 1.1.

## Endpoints

### Campaign Management

#### Get Campaign Performance
```
GET /api/sync_performance.php
```

**Parameters:**
- `user_id` (required): User ID
- `platform` (optional): 'google_ads' or 'facebook_ads'
- `start_date` (optional): Start date (YYYY-MM-DD)
- `end_date` (optional): End date (YYYY-MM-DD)

**Response:**
```json
{
  "success": true,
  "data": [
    {
      "ad_id": "12345",
      "impressions": 1000,
      "clicks": 50,
      "conversions": 5,
      "cost": 25.50,
      "revenue": 150.00
    }
  ]
}
```

#### Track User Metrics
```
POST /api/metrics_tracking.php
```

**Request Body:**
```json
{
  "user_id": 1,
  "session_id": "abc123",
  "page_url": "/page",
  "conversion_type": "purchase",
  "conversion_value": 99.99
}
```

### Email Service

#### Send Email Campaign
```
POST /api/email_service.php
```

**Request Body:**
```json
{
  "campaign_id": 1,
  "recipients": ["email@example.com"],
  "subject": "Campaign Subject",
  "content": "Email content HTML"
}
```

### Reporting

#### Generate Daily Report
```
GET /api/generate_daily_reports.php
```

**Parameters:**
- `user_id` (required): User ID
- `date` (optional): Report date (default: today)

## Error Handling

All API endpoints return JSON responses:

**Success:**
```json
{
  "success": true,
  "data": {...}
}
```

 terribleError:**
```json
{
  "success": false,
  "error": "Error message"
}
```

## Status Codes

- `200 OK`: Request successful
- `400 Bad Request`: Invalid parameters
- `401 Unauthorized`: Authentication required
- `403 Forbidden`: Insufficient permissions
- `404 Not Found`: Resource not found
- `500 Internal Server Error`: Server error

## Rate Limiting

Rate limiting will be implemented in a future version.

## Changelog

### Version 1.0
- Initial API structure
- Basic campaign tracking
- Email service endpoints

### Version 1.1 (Planned)
- Token-based authentication
- Webhook support
- Enhanced reporting endpoints
- Rate limiting

