# AcceleratedLeadz Setup Guide

## Overview
AcceleratedLeadz is an email automation system that:
- Processes IMAP emails from roundbox
- Sends automated emails to CRM customers at a rate of 1 email per minute (like Mailchimp)
- Integrates with the existing CRM system

## Database Setup

First, run the migration to create the required tables:

```bash
mysql -u your_user -p your_database < database/migrations/005_acceleratedleadz_acceleratedadz.sql
```

Or import the SQL directly into your database.

## IMAP Configuration

Configure IMAP settings in `config/email_config.php` or use environment variables:

```php
define('IMAP_HOST', 'imap.roundbox.com');  // Your roundbox IMAP host
define('IMAP_PORT', 993);
define('IMAP_ENCRYPTION', 'ssl');
define('IMAP_USER', 'your-email@domain.com');
define('IMAP_PASS', 'your-password');
define('IMAP_MAILBOX', 'INBOX');
```

## Email Queue Worker Setup (Cron Job)

The email queue worker must run every minute to send emails at the rate of 1 per minute.

### Linux/Unix Cron Setup

Add this line to your crontab (run `crontab -e`):

```bash
* * * * * /usr/bin/php /path/to/mk/market/api/acceleratedleadz_worker.php >> /path/to/logs/acceleratedleadz_worker.log 2>&1
```

Replace `/path/to/mk/market/api/acceleratedleadz_worker.php` with your actual path.

### Windows Task Scheduler

1. Open Task Scheduler
2. Create Basic Task
3. Name it "AcceleratedLeadz Email Worker"
4. Trigger: Daily, repeat every 1 minute
5. Action: Start a program
   - Program: `C:\xampp\php\php.exe` (or your PHP path)
   - Arguments: `C:\xampp\htdocs\1.2\mk\market\api\acceleratedleadz_worker.php`
   - Start in: `C:\xampp\htdocs\1.2\mk\market\api`

### Testing the Worker

You can test the worker manually:

```bash
php api/acceleratedleadz_worker.php
```

Or via web browser:
```
https://ai-itinc.com/api/acceleratedleadz_worker.php
```

## API Endpoints

All endpoints are available at `https://ai-itinc.com/api/acceleratedleadz.php`

### Process IMAP Emails
```
GET ?action=process_imap&user_id=123
```

### Create Campaign
```
POST action=create_campaign
POST campaign_name=My Campaign
POST campaign_type=drip
POST send_rate=1
```

### Queue Email to Customer
```
POST action=queue_email
POST campaign_id=1
POST subscriber_id=123
POST subject=Email Subject
POST content=<html>Email Content</html>
```

### Get Campaigns
```
GET ?action=get_campaigns
```

### Get Queue Stats
```
GET ?action=get_queue_stats
```

## Usage Workflow

1. **Create a Campaign**: Use the client interface at `/client/acceleratedleadz.php` or via API
2. **Process IMAP Emails**: Click "Process IMAP Emails" button to fetch emails from roundbox
3. **Queue Emails**: Add emails to the queue using the API or automatically based on triggers
4. **Worker Sends Emails**: The cron job sends 1 email per minute from the queue
5. **Monitor**: View stats and logs in the client interface

## Email Personalization

Emails support template variables:
- `{{first_name}}` - Customer's first name
- `{{last_name}}` - Customer's last name
- `{{email}}` - Customer's email address

Example:
```html
<h1>Hello {{first_name}},</h1>
<p>Thank you for subscribing!</p>
```

## Troubleshooting

### Worker Not Sending Emails

1. Check if cron job is running: `ps aux | grep acceleratedleadz_worker`
2. Check PHP CLI path: `which php`
3. Check file permissions: Ensure PHP can read/write to database
4. Check logs: Review error logs in your PHP error log

### IMAP Connection Issues

1. Verify IMAP settings in `config/email_config.php`
2. Test IMAP connection manually:
```php
$inbox = imap_open('{imap.roundbox.com:993/ssl}INBOX', 'user', 'pass');
if (!$inbox) {
    echo "Error: " . imap_last_error();
}
```

### Emails Not Queuing

1. Verify campaign exists and is active
2. Check subscriber status (must be 'subscribed')
3. Verify scheduled_at date is in the future or current

## Security Notes

- The worker should run with limited permissions
- Store IMAP credentials securely (use environment variables)
- Use HTTPS for all API calls
- Implement rate limiting for API endpoints

## Support

For issues or questions, contact: support@ai-itinc.com

