# .env File Quick Reference

## What is .env?

The `.env` file stores your secret passwords and API keys. It's like a vault for your app's secrets!

## Security Rules 🔒

1. ✅ **NEVER** commit `.env` to Git/GitHub
2. ✅ **NEVER** share `.env` with anyone
3. ✅ **ALWAYS** keep `.env` on your server only
4. ✅ **ALWAYS** back up `.env` securely (password-protected)

## Quick Setup

1. Copy `env.example` to `.env`
2. Fill in your actual values
3. Save the file
4. Set permissions to 600 (read/write for owner only)

## Required Settings (Minimum)

```env
# Database (Required)
DB_HOST=localhost
DB_NAME=mindsybq_market
DB_USER=mindsybq_appuser
DB_PASS=your_password_here

# Security (Required)
SECRET_KEY=your_random_32_character_string_here
```

## Optional Settings

### Google Ads
```env
GOOGLE_ADS_CLIENT_ID=
GOOGLE_ADS_CLIENT_SECRET=
GOOGLE_ADS_DEVELOPER_TOKEN=
```

### Facebook Ads
```env
FACEBOOK_APP_ID=
FACEBOOK_APP_SECRET=
FACEBOOK_ACCESS_TOKEN=
```

### Email (SMTP)
```env
EMAIL_SERVICE=smtp
SMTP_HOST=smtp.gmail.com
SMTP_PORT=587
SMTP_USER=your_email@gmail.com
SMTP_PASS=your_app_password
```

## Generate Secret Key

Use any of these methods:
- Visit: https://randomkeygen.com/
- Use PHP: `echo bin2hex(random_bytes(32));`
- Use command line: `openssl rand -hex 32`

## Troubleshooting

**Problem:** Config not loading
- Check `.env` file exists in `market/` folder
- Check file is named exactly `.env` (with dot)
- Check no syntax errors (every line should be `KEY=VALUE`)

**Problem:** Database connection fails
- Verify DB_NAME matches your actual database name
- Verify DB_USER matches your actual database user
- Check DB_PASS is correct (no extra spaces)

**Problem:** Permissions error
- Try setting file permissions to 644 or 600
- Check file owner matches web server user

