-- Marketing Service Platform Database Schema
-- MySQL 8.0+ (Complete with all indexes)
-- Run this after schema.sql to add all performance indexes

USE marketing_platform;

-- Add performance indexes to existing tables
-- Note: These are added as separate statements for existing databases

-- Users table indexes
ALTER TABLE users ADD INDEX IF NOT EXISTS idx_role_status (role, status);
ALTER TABLE users ADD INDEX IF NOT EXISTS idx_business_name (business_name);
ALTER TABLE users ADD INDEX IF NOT EXISTS idx_role_business (role, business_name);
ALTER TABLE users ADD INDEX IF NOT EXISTS idx_contact_name (contact_name);
ALTER TABLE users ADD INDEX IF NOT EXISTS idx_created_at (created_at DESC);

-- Subscriptions table indexes
ALTER TABLE subscriptions ADD INDEX IF NOT EXISTS idx_user_status (user_id, status);
ALTER TABLE subscriptions ADD INDEX IF NOT EXISTS idx_user_tier_status (user_id, tier_id, status);

-- Campaigns table indexes
ALTER TABLE campaigns ADD INDEX IF NOT EXISTS idx_user_status_type (user_id, status, campaign_type);

-- Discount codes table indexes
ALTER TABLE discount_codes ADD INDEX IF NOT EXISTS idx_user_status_expiry (user_id, status, end_date);

-- Email campaigns table indexes
ALTER TABLE email_campaigns ADD INDEX IF NOT EXISTS idx_user_status_created (user_id, status, created_at DESC);

-- Ad performance table indexes
ALTER TABLE ad_performance ADD INDEX IF NOT EXISTS idx_user_date (user_id, date DESC);

-- User metrics table indexes
ALTER TABLE user_metrics ADD INDEX IF NOT EXISTS idx_user_visited (user_id, visited_at DESC);

-- Transactions table indexes
ALTER TABLE transactions ADD INDEX IF NOT EXISTS idx_user_date_status (user_id, created_at DESC, payment_status);

