-- Migration: Add email rate limiting and queue support
-- Run this migration to add daily_limit column and email_campaign_queue table

-- Add daily_limit and daily_sent_count to email_campaigns
ALTER TABLE email_campaigns 
ADD COLUMN IF NOT EXISTS daily_limit INT DEFAULT NULL,
ADD COLUMN IF NOT EXISTS daily_sent_count INT DEFAULT 0,
ADD COLUMN IF NOT EXISTS last_sent_date DATE DEFAULT NULL;

-- Create email campaign queue table for rate-limited sending
CREATE TABLE IF NOT EXISTS email_campaign_queue (
    id BIGINT UNSIGNED AUTO_INCREMENT PRIMARY KEY,
    email_campaign_id INT UNSIGNED NOT NULL,
    email VARCHAR(255) NOT NULL,
    first_name VARCHAR(100),
    last_name VARCHAR(100),
    status ENUM('pending', 'sending', 'sent', 'failed') DEFAULT 'pending',
    error_message TEXT,
    queued_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    sent_at TIMESTAMP NULL,
    FOREIGN KEY (email_campaign_id) REFERENCES email_campaigns(id) ON DELETE CASCADE,
    INDEX idx_campaign_status (email_campaign_id, status),
    INDEX idx_status_queued (status, queued_at),
    INDEX idx_email (email)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

