-- Migration: Admin-Client Assignments
-- Creates relationship between admin users and client users

CREATE TABLE IF NOT EXISTS admin_client_assignments (
    id INT UNSIGNED AUTO_INCREMENT PRIMARY KEY,
    admin_id INT UNSIGNED NOT NULL,
    client_id INT UNSIGNED NOT NULL,
    assigned_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    assigned_by INT UNSIGNED, -- Admin who made the assignment
    notes TEXT,
    FOREIGN KEY (admin_id) REFERENCES users(id) ON DELETE CASCADE,
    FOREIGN KEY (client_id) REFERENCES users(id) ON DELETE CASCADE,
    FOREIGN KEY (assigned_by) REFERENCES users(id) ON DELETE SET NULL,
    UNIQUE KEY unique_admin_client (admin_id, client_id),
    INDEX idx_admin_id (admin_id),
    INDEX idx_client_id (client_id),
    INDEX idx_assigned_at (assigned_at DESC)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Create index for client access queries
CREATE INDEX idx_admin_client_access ON admin_client_assignments(admin_id, client_id);

