-- Migration: Add Activity Logging Table
-- Version: 1.2
-- Date: 2025-10-29

-- Admin Activity Log Table
CREATE TABLE IF NOT EXISTS admin_activity_log (
    id BIGINT UNSIGNED AUTO_INCREMENT PRIMARY KEY,
    admin_id INT UNSIGNED NOT NULL,
    action_type ENUM('create', 'update', 'delete', 'activate', 'deactivate', 'suspend', 'export', 'login', 'logout', 'bulk_action') NOT NULL,
    entity_type VARCHAR(50) NOT NULL, -- 'user', 'subscription', 'campaign', etc.
    entity_id INT UNSIGNED,
    description TEXT,
    old_values JSON,
    new_values JSON,
    affected_count INT DEFAULT 1, -- For bulk actions
    ip_address VARCHAR(45),
    user_agent TEXT,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    FOREIGN KEY (admin_id) REFERENCES users(id) ON DELETE CASCADE,
    INDEX idx_admin_id (admin_id),
    INDEX idx_action_type (action_type),
    INDEX idx_entity_type (entity_type),
    INDEX idx_created_at (created_at DESC),
    INDEX idx_admin_created (admin_id, created_at DESC),
    INDEX idx_entity (entity_type, entity_id)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

