-- Performance Optimization Indexes
-- Run this after initial schema setup to improve query performance

USE marketing_platform;

-- Composite index for common user queries (role + status filtering)
-- Used frequently in admin/client listing pages
ALTER TABLE users ADD INDEX idx_role_status (role, status);

-- Index for business name searches
-- Used in client search functionality
ALTER TABLE users ADD INDEX idx_business_name (business_name);

-- Composite index for business name search with role filter
ALTER TABLE users ADD INDEX idx_role_business (role, business_name);

-- Index for contact name searches
ALTER TABLE users ADD INDEX idx_contact_name (contact_name);

-- Composite index for subscriptions query (user_id + status)
-- Used frequently to get active subscriptions
ALTER TABLE subscriptions ADD INDEX idx_user_status (user_id, status);

-- Index for created_at for sorting
-- Used for ordering by date created
ALTER TABLE users ADD INDEX idx_created_at (created_at DESC);

-- Composite index for subscription queries with tier joins
ALTER TABLE subscriptions ADD INDEX idx_user_tier_status (user_id, tier_id, status);

-- Index for campaign queries
ALTER TABLE campaigns ADD INDEX idx_user_status_type (user_id, status, campaign_type);

-- Index for date range queries on ad performance
ALTER TABLE ad_performance ADD INDEX idx_user_date (user_id, date DESC);

-- Composite index for user metrics date range queries
ALTER TABLE user_metrics ADD INDEX idx_user_visited (user_id, visited_at DESC);

-- Index for email campaign queries
ALTER TABLE email_campaigns ADD INDEX idx_user_status_created (user_id, status, created_at DESC);

-- Index for discount code lookups
ALTER TABLE discount_codes ADD INDEX idx_user_status_expiry (user_id, status, end_date);

-- Index for transaction queries
ALTER TABLE transactions ADD INDEX idx_user_date_status (user_id, created_at DESC, payment_status);

