<?php
/**
 * Quick Database Creation Script
 * Creates the database if it doesn't exist
 * 
 * Run: php create_database.php
 */

require_once __DIR__ . '/config/database.php';

try {
    // Connect to MySQL without selecting a database
    $pdo = new PDO("mysql:host=" . DB_HOST . ";charset=" . DB_CHARSET, DB_USER, DB_PASS);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    
    // Create database
    $pdo->exec("CREATE DATABASE IF NOT EXISTS `" . DB_NAME . "` CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci");
    
    echo "✓ Database '" . DB_NAME . "' created successfully!\n";
    echo "\nNext steps:\n";
    echo "1. Import the unified schema: mysql -u " . DB_USER . " " . DB_NAME . " < database/schema_main.sql\n";
    echo "   OR run setup.php via browser: http://localhost/accelerated-market/setup.php\n";
    
} catch (PDOException $e) {
    echo "✗ Error: " . $e->getMessage() . "\n";
    echo "\nPlease check:\n";
    echo "- MySQL is running\n";
    echo "- Database credentials in config/database.php are correct\n";
    exit(1);
}

