<?php
/**
 * Production Configuration
 * Settings optimized for shared hosting (Namecheap)
 */

// Error reporting - DISABLE in production
ini_set('display_errors', '0');
ini_set('display_startup_errors', '0');
error_reporting(0); // Disable all error reporting in production

// Log errors to file instead
ini_set('log_errors', '1');
$logFile = __DIR__ . '/../logs/php_errors.log';
if (!is_dir(dirname($logFile))) {
    @mkdir(dirname($logFile), 0755, true);
}
ini_set('error_log', $logFile);

// Session configuration for shared hosting
if (!isset($_SESSION) && session_status() === PHP_SESSION_NONE) {
    // Use default session save path (shared hosting compatible)
    // Some hosts require sessions to be in a specific directory
    $sessionPath = session_save_path();
    if (empty($sessionPath) || !is_writable($sessionPath)) {
        // Use a writable directory within the app
        $customSessionPath = __DIR__ . '/../tmp/sessions';
        if (!is_dir($customSessionPath)) {
            @mkdir($customSessionPath, 0755, true);
        }
        if (is_writable($customSessionPath)) {
            session_save_path($customSessionPath);
        }
    }
    
    // Session security settings
    ini_set('session.cookie_httponly', '1');
    ini_set('session.cookie_secure', '1'); // Use only over HTTPS
    ini_set('session.use_strict_mode', '1');
    ini_set('session.cookie_samesite', 'Strict');
    
    // Session lifetime (2 hours)
    ini_set('session.gc_maxlifetime', '7200');
}

// Timezone
if (!ini_get('date.timezone')) {
    date_default_timezone_set('America/New_York'); // Change to your timezone
}

// Memory and execution limits
@ini_set('memory_limit', '256M');
@ini_set('max_execution_time', '300');
@ini_set('max_input_time', '300');

// Disable dangerous functions (if allow_url_fopen is restricted)
@ini_set('allow_url_fopen', '1'); // Some shared hosts disable this

// Prevent script timeout issues
if (function_exists('set_time_limit')) {
    @set_time_limit(300);
}

