<?php
/**
 * Environment Configuration Loader
 * Safely loads .env file and sets constants
 * 
 * Usage: require_once __DIR__ . '/env_loader.php';
 */

if (!file_exists(__DIR__ . '/../.env')) {
    // Don't die in production, just return - configs will use defaults
    return;
}

$envFile = __DIR__ . '/../.env';
$lines = @file($envFile, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);

if (!$lines) {
    return;
}

foreach ($lines as $line) {
    $line = trim($line);
    
    // Skip empty lines and comments
    if (empty($line) || strpos($line, '#') === 0) {
        continue;
    }
    
    // Parse KEY=VALUE format
    if (strpos($line, '=') !== false) {
        list($key, $value) = explode('=', $line, 2);
        $key = trim($key);
        $value = trim($value);
        
        // Remove quotes if present
        $value = trim($value, '"\'');
        
        // Set as constant if not already defined
        // Use @define() to suppress warnings if constant already exists
        if (!empty($key) && !defined($key)) {
            @define($key, $value);
        }
    }
}

