<?php
/**
 * Email Service Configuration
 * Supports SMTP via PHPMailer, SendGrid, or Mailchimp
 * Loads from .env file for security
 */

// Load environment variables if .env exists
if (file_exists(__DIR__ . '/../.env')) {
    require_once __DIR__ . '/env_loader.php';
}

// Email Service
define('EMAIL_SERVICE', defined('EMAIL_SERVICE') ? EMAIL_SERVICE : 'smtp'); // 'smtp', 'sendgrid' or 'mailchimp'

// SendGrid Configuration
define('SENDGRID_API_KEY', defined('SENDGRID_API_KEY') ? SENDGRID_API_KEY : '');
define('SENDGRID_FROM_EMAIL', defined('SENDGRID_FROM_EMAIL') ? SENDGRID_FROM_EMAIL : '');
define('SENDGRID_FROM_NAME', defined('SENDGRID_FROM_NAME') ? SENDGRID_FROM_NAME : 'Marketing Platform');

// Mailchimp Configuration
define('MAILCHIMP_API_KEY', defined('MAILCHIMP_API_KEY') ? MAILCHIMP_API_KEY : '');
define('MAILCHIMP_SERVER_PREFIX', defined('MAILCHIMP_SERVER_PREFIX') ? MAILCHIMP_SERVER_PREFIX : '');
define('MAILCHIMP_FROM_EMAIL', defined('MAILCHIMP_FROM_EMAIL') ? MAILCHIMP_FROM_EMAIL : '');
define('MAILCHIMP_FROM_NAME', defined('MAILCHIMP_FROM_NAME') ? MAILCHIMP_FROM_NAME : 'Marketing Platform');

// SMTP (PHPMailer) Configuration
// Provide defaults; can be overridden per-user via credentials table
define('SMTP_HOST', defined('SMTP_HOST') ? SMTP_HOST : '');
define('SMTP_PORT', defined('SMTP_PORT') ? SMTP_PORT : 465);
define('SMTP_USER', defined('SMTP_USER') ? SMTP_USER : '');
define('SMTP_PASS', defined('SMTP_PASS') ? SMTP_PASS : '');
define('SMTP_SECURE', defined('SMTP_SECURE') ? SMTP_SECURE : 'ssl'); // tls|ssl|''
define('SMTP_FROM_EMAIL', defined('SMTP_FROM_EMAIL') ? SMTP_FROM_EMAIL : '');
define('SMTP_FROM_NAME', defined('SMTP_FROM_NAME') ? SMTP_FROM_NAME : 'Marketing Platform');

// IMAP settings for automation/ingest
define('IMAP_HOST', defined('IMAP_HOST') ? IMAP_HOST : '');
define('IMAP_PORT', defined('IMAP_PORT') ? IMAP_PORT : 993);
define('IMAP_ENCRYPTION', defined('IMAP_ENCRYPTION') ? IMAP_ENCRYPTION : 'ssl'); // ssl|tls|''
define('IMAP_USER', defined('IMAP_USER') ? IMAP_USER : '');
define('IMAP_PASS', defined('IMAP_PASS') ? IMAP_PASS : '');
define('IMAP_MAILBOX', defined('IMAP_MAILBOX') ? IMAP_MAILBOX : 'INBOX');

// IMAP Sent folder - where to save sent emails (Namecheap uses "Sent", "Sent Messages", or "INBOX.Sent")
define('IMAP_SENT_FOLDER', defined('IMAP_SENT_FOLDER') ? IMAP_SENT_FOLDER : 'Sent');

