<?php
/**
 * Domain Configuration
 * Handles local development and production domain settings
 * 
 * ai-itinc.com is the main hosting site
 * affiliate-it.com is hosted on ai-itinc.com (same server/directory)
 */

// Detect environment
$isLocal = (
    $_SERVER['HTTP_HOST'] === 'localhost' ||
    $_SERVER['HTTP_HOST'] === '127.0.0.1' ||
    strpos($_SERVER['HTTP_HOST'], '.local') !== false ||
    strpos($_SERVER['HTTP_HOST'], '.test') !== false ||
    $_SERVER['HTTP_HOST'] === 'affiliate-iti.local' ||
    $_SERVER['HTTP_HOST'] === 'ai-itinc.local'
);

// Determine current domain
$currentHost = $_SERVER['HTTP_HOST'] ?? 'localhost';
$isMainDomain = (
    strpos($currentHost, 'ai-itinc.com') !== false ||
    strpos($currentHost, 'ai-itinc.local') !== false ||
    ($isLocal && strpos($currentHost, 'ai-itinc') !== false)
);

$isAffiliateDomain = (
    strpos($currentHost, 'affiliate-it.com') !== false ||
    strpos($currentHost, 'affiliate-it.local') !== false ||
    ($isLocal && strpos($currentHost, 'affiliate') !== false)
);

// Prevent redefinition - only define if not already defined
if (!defined('MAIN_DOMAIN')) {
    // Domain configuration
    if ($isLocal) {
        // Local development
        define('MAIN_DOMAIN', 'ai-itinc.local');
        define('AFFILIATE_DOMAIN', 'affiliate-it.local');
        define('AD_DOMAIN', 'ai-itinc.local');
        define('LEAD_DOMAIN', 'ai-itinc.local');
        define('BASE_URL', 'http://' . $currentHost);
        define('MAIN_BASE_URL', 'http://ai-itinc.local');
        define('AD_BASE_URL', 'http://ai-itinc.local');
        define('LEAD_BASE_URL', 'http://ai-itinc.local');
    } else {
        // Production
        define('MAIN_DOMAIN', 'ai-itinc.com');
        define('AFFILIATE_DOMAIN', 'affiliate-it.com'); // Points to ai-itinc.com
        define('AD_DOMAIN', 'ai-itinc.com');
        define('LEAD_DOMAIN', 'ai-itinc.com');
        define('BASE_URL', 'https://' . $currentHost);
        define('MAIN_BASE_URL', 'https://ai-itinc.com');
        define('AD_BASE_URL', 'https://ai-itinc.com');
        define('LEAD_BASE_URL', 'https://ai-itinc.com');
    }
    
    // Paths
    define('MAIN_PATH', '/mk/market');
    define('AD_PATH', '/acceleratedadz.php');
    define('LEAD_PATH', '/acceleratedleadz.php');
    
    // Full URLs (must be after BASE_URL constants)
    define('MAIN_URL', MAIN_BASE_URL . MAIN_PATH);
    define('AD_URL', AD_BASE_URL . AD_PATH);
    define('LEAD_URL', LEAD_BASE_URL . LEAD_PATH);
    
    // API URLs
    define('API_BASE_URL', MAIN_BASE_URL . MAIN_PATH . '/api');
}

// Helper functions
function getAdUrl($adId, $params = []) {
    $url = AD_URL . '?id=' . $adId;
    if (!empty($params)) {
        $url .= '&' . http_build_query($params);
    }
    return $url;
}

function getLeadUrl($params = []) {
    $url = LEAD_URL;
    if (!empty($params)) {
        $url .= '?' . http_build_query($params);
    }
    return $url;
}

function getApiUrl($endpoint = '') {
    return API_BASE_URL . '/' . ltrim($endpoint, '/');
}

function isMainDomain() {
    global $isMainDomain;
    return $isMainDomain ?? false;
}

function isLocalEnv() {
    global $isLocal;
    return $isLocal;
}

// Make variables available globally
$GLOBALS['isLocal'] = $isLocal;
$GLOBALS['isMainDomain'] = $isMainDomain;

