<?php
/**
 * Test Database Configuration
 * Used for running tests with a separate test database
 * 
 * IMPORTANT: Create a separate test database before running tests
 * Example: CREATE DATABASE mindsybq_market_test;
 */

// Test database settings
define('TEST_DB_HOST', 'localhost');
define('TEST_DB_NAME', 'mindsybq_market_test');
define('TEST_DB_USER', 'root'); // Change to your test DB user
define('TEST_DB_PASS', ''); // Change to your test DB password
define('TEST_DB_CHARSET', 'utf8mb4');

// Test environment settings
define('TEST_ENV', true);
define('TEST_RESET_DB', true); // Set to true to recreate tables on each test run

// Path to SQL schema file (unified schema_main.sql contains all tables and migrations)
define('TEST_SCHEMA_PATH', __DIR__ . '/../database/schema_main.sql');

// Test data settings
define('TEST_SEED_DATA', true); // Automatically seed test data

