<?php
/**
 * Database Configuration
 * Loads from .env file for security
 * 
 * Prevents redefinition errors by checking constants before defining
 */

// Prevent multiple includes
if (defined('DB_CONFIG_LOADED')) {
    return;
}

// Load environment variables if .env exists
if (file_exists(__DIR__ . '/../.env')) {
    require_once __DIR__ . '/env_loader.php';
}

// Set defaults if not already defined (prevents redefinition warnings)
// Use @define() to suppress warnings if constant already exists
if (!defined('DB_HOST')) {
    @define('DB_HOST', 'localhost');
}
if (!defined('DB_NAME')) {
    @define('DB_NAME', 'mindsybq_market');
}
if (!defined('DB_USER')) {
    @define('DB_USER', 'mindsybq_appuser');
}
if (!defined('DB_PASS')) {
    @define('DB_PASS', 'M@rket-2025$');
}
if (!defined('DB_CHARSET')) {
    @define('DB_CHARSET', 'utf8mb4');
}

// Mark as loaded to prevent re-execution
define('DB_CONFIG_LOADED', true);

