<?php
/**
 * Webhooks Management Dashboard
 * Create and manage webhooks for event notifications
 */

require_once __DIR__ . '/../includes/auth.php';
require_once __DIR__ . '/../includes/functions.php';

requireClient();
$pageTitle = 'Webhooks';

$userId = $_SESSION['user_id'];
$db = getDB();

// Get webhooks
$stmt = $db->prepare("SELECT * FROM webhooks WHERE user_id = ? ORDER BY created_at DESC");
$stmt->execute([$userId]);
$webhooks = $stmt->fetchAll();

foreach ($webhooks as &$webhook) {
    $webhook['events'] = json_decode($webhook['events'], true);
}

require_once __DIR__ . '/../includes/header.php';
require_once __DIR__ . '/../includes/csrf.php';
?>

<div class="row mb-4">
    <div class="col-12">
        <div class="d-flex justify-content-between align-items-center">
            <h1><i class="bi bi-link-45deg"></i> Webhooks</h1>
            <button class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#createWebhookModal">
                <i class="bi bi-plus-circle"></i> Create Webhook
            </button>
        </div>
    </div>
</div>

<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-body">
                <?php if (empty($webhooks)): ?>
                    <p class="text-muted text-center py-5">No webhooks configured. Create one to receive event notifications!</p>
                <?php else: ?>
                    <div class="table-responsive">
                        <table class="table table-striped">
                            <thead>
                                <tr>
                                    <th>Name</th>
                                    <th>URL</th>
                                    <th>Events</th>
                                    <th>Status</th>
                                    <th>Last Triggered</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach ($webhooks as $webhook): ?>
                                    <tr>
                                        <td><strong><?= escape($webhook['webhook_name']) ?></strong></td>
                                        <td><code><?= escape($webhook['webhook_url']) ?></code></td>
                                        <td>
                                            <?php foreach ($webhook['events'] as $event): ?>
                                                <span class="badge bg-secondary"><?= escape($event) ?></span>
                                            <?php endforeach; ?>
                                        </td>
                                        <td>
                                            <span class="badge bg-<?= $webhook['status'] === 'active' ? 'success' : ($webhook['status'] === 'failed' ? 'danger' : 'warning') ?>">
                                                <?= escape($webhook['status']) ?>
                                            </span>
                                        </td>
                                        <td>
                                            <?php if ($webhook['last_triggered_at']): ?>
                                                <?= formatDateTime($webhook['last_triggered_at']) ?>
                                            <?php else: ?>
                                                <span class="text-muted">Never</span>
                                            <?php endif; ?>
                                        </td>
                                        <td>
                                            <div class="btn-group btn-group-sm">
                                                <button class="btn btn-info btn-sm test-webhook-btn" data-id="<?= $webhook['id'] ?>">
                                                    <i class="bi bi-play-circle"></i> Test
                                                </button>
                                                <a href="?logs=<?= $webhook['id'] ?>" class="btn btn-secondary btn-sm">
                                                    <i class="bi bi-clock-history"></i> Logs
                                                </a>
                                            </div>
                                        </td>
                                    </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    document.querySelectorAll('.test-webhook-btn').forEach(btn => {
        btn.addEventListener('click', function() {
            const webhookId = this.dataset.id;
            
            const formData = new FormData();
            formData.append('action', 'test');
            formData.append('webhook_id', webhookId);
            formData.append('csrf_token', '<?= $_SESSION['csrf_token'] ?? '' ?>');
            
            fetch('<?= url('api/webhooks.php') ?>', {
                method: 'POST',
                body: formData
            })
            .then(r => r.json())
            .then(data => {
                if (data.success) {
                    alert('Webhook test successful! HTTP ' + data.http_code);
                } else {
                    alert('Webhook test failed: ' + (data.error || 'HTTP ' + data.http_code));
                }
            });
        });
    });
});
</script>

<?php require_once __DIR__ . '/../includes/footer.php'; ?>

