<?php
/**
 * Tracking Code Generator
 * Provides embeddable tracking code for client websites
 */

require_once __DIR__ . '/../includes/auth.php';
require_once __DIR__ . '/../includes/functions.php';

requireClient();
$pageTitle = 'Tracking Code';

$userId = $_SESSION['user_id'];
$user = getCurrentUser();

require_once __DIR__ . '/../includes/header.php';
?>

<div class="row">
    <div class="col-12 mb-4">
        <h1>Tracking Code</h1>
        <p class="text-muted">Embed this code on your website to track visitor metrics and conversions</p>
    </div>
</div>

<div class="row">
    <div class="col-12 mb-4">
        <div class="card">
            <div class="card-header">
                <h5 class="mb-0">JavaScript Tracking Code</h5>
            </div>
            <div class="card-body">
                <p>Copy and paste this code before the closing <code>&lt;/body&gt;</code> tag on all pages you want to track:</p>
                <div class="bg-light p-3 rounded mb-3">
                    <pre id="trackingCode" class="mb-0"><code>&lt;script&gt;
var TRACKING_USER_ID = <?= $userId ?>;
&lt;/script&gt;
&lt;script src="<?= (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? 'https' : 'http') ?>://<?= $_SERVER['HTTP_HOST'] ?>/assets/js/main.js"&gt;&lt;/script&gt;</code></pre>
                </div>
                <button class="btn btn-primary" onclick="copyTrackingCode()">
                    <i class="bi bi-clipboard"></i> Copy Code
                </button>
            </div>
        </div>
    </div>
</div>

<div class="row">
    <div class="col-md-6 mb-4">
        <div class="card">
            <div class="card-header">
                <h5 class="mb-0">Manual Conversion Tracking</h5>
            </div>
            <div class="card-body">
                <p>Track conversions manually on specific actions (e.g., purchase, signup):</p>
                <div class="bg-light p-3 rounded mb-3">
                    <pre class="mb-0"><code>&lt;script&gt;
trackMetric(<?= $userId ?>, {
    conversion_type: 'purchase',
    conversion_value: 99.99,
    discount_code_used: 'SAVE20'
});
&lt;/script&gt;</code></pre>
                </div>
            </div>
        </div>
    </div>
    
    <div class="col-md-6 mb-4">
        <div class="card">
            <div class="card-header">
                <h5 class="mb-0">UTM Parameter Tracking</h5>
            </div>
            <div class="card-body">
                <p>UTM parameters are automatically captured from your campaign URLs. Example:</p>
                <div class="bg-light p-3 rounded mb-3">
                    <pre class="mb-0"><code>https://yourwebsite.com?
utm_source=google
&utm_medium=cpc
&utm_campaign=summer_sale
&utm_term=restaurant
&utm_content=ad1</code></pre>
                </div>
                <p class="text-muted small">The tracking code automatically captures these parameters and associates them with visits.</p>
            </div>
        </div>
    </div>
</div>

<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-header">
                <h5 class="mb-0">Tracking Pixel (Alternative)</h5>
            </div>
            <div class="card-body">
                <p>If you prefer a simple tracking pixel instead:</p>
                <div class="bg-light p-3 rounded mb-3">
                    <pre id="pixelCode" class="mb-0"><code>&lt;img src="<?= (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? 'https' : 'http') ?>://<?= $_SERVER['HTTP_HOST'] ?>/api/metrics_tracking.php?user_id=<?= $userId ?>" width="1" height="1" style="display:none;"&gt;</code></pre>
                </div>
                <button class="btn btn-secondary" onclick="copyPixelCode()">
                    <i class="bi bi-clipboard"></i> Copy Pixel Code
                </button>
            </div>
        </div>
    </div>
</div>

<script>
function copyTrackingCode() {
    const code = document.getElementById('trackingCode').textContent;
    navigator.clipboard.writeText(code).then(function() {
        alert('Tracking code copied to clipboard!');
    });
}

function copyPixelCode() {
    const code = document.getElementById('pixelCode').textContent;
    navigator.clipboard.writeText(code).then(function() {
        alert('Pixel code copied to clipboard!');
    });
}
</script>

<?php require_once __DIR__ . '/../includes/footer.php'; ?>

