<?php
/**
 * Settings Save Handler
 * Processes credential saving with proper multi-field support
 */

require_once __DIR__ . '/../includes/auth.php';
require_once __DIR__ . '/../includes/functions.php';

requireClient();

$userId = $_SESSION['user_id'];
$db = getDB();

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $action = $_POST['action'] ?? '';
    $serviceName = $_POST['service_name'] ?? '';
    
    if ($action === 'save_credentials' && !empty($serviceName)) {
        $encryptionKey = getenv('ENCRYPTION_KEY') ?: 'default_key_change_in_production';
        
        // Build credentials array based on service
        $credentialsData = [];
        $hasCredentials = false;
        
        if ($serviceName === 'google_ads') {
            if (!empty($_POST['client_id'])) $credentialsData['client_id'] = $_POST['client_id'];
            if (!empty($_POST['client_secret'])) $credentialsData['client_secret'] = $_POST['client_secret'];
            if (!empty($_POST['developer_token'])) $credentialsData['developer_token'] = $_POST['developer_token'];
            if (!empty($_POST['refresh_token'])) $credentialsData['refresh_token'] = $_POST['refresh_token'];
            if (!empty($_POST['customer_id'])) $credentialsData['customer_id'] = $_POST['customer_id'];
            $hasCredentials = !empty($credentialsData);
            $credentialKey = 'credentials';
        } elseif ($serviceName === 'facebook_ads') {
            if (!empty($_POST['app_id'])) $credentialsData['app_id'] = $_POST['app_id'];
            if (!empty($_POST['app_secret'])) $credentialsData['app_secret'] = $_POST['app_secret'];
            if (!empty($_POST['access_token'])) $credentialsData['access_token'] = $_POST['access_token'];
            if (!empty($_POST['ad_account_id'])) $credentialsData['ad_account_id'] = $_POST['ad_account_id'];
            $hasCredentials = !empty($credentialsData);
            $credentialKey = 'access_token';
        } elseif ($serviceName === 'sendgrid') {
            if (!empty($_POST['api_key'])) {
                $credentialsData['api_key'] = $_POST['api_key'];
                $hasCredentials = true;
            }
            if (!empty($_POST['from_email'])) $credentialsData['from_email'] = $_POST['from_email'];
            if (!empty($_POST['from_name'])) $credentialsData['from_name'] = $_POST['from_name'];
            $credentialKey = 'api_key';
        } elseif ($serviceName === 'mailchimp') {
            if (!empty($_POST['api_key'])) {
                $credentialsData['api_key'] = $_POST['api_key'];
                $hasCredentials = true;
            }
            if (!empty($_POST['server_prefix'])) $credentialsData['server_prefix'] = $_POST['server_prefix'];
            $credentialKey = 'api_key';
        }
        
        if ($hasCredentials) {
            // Encrypt the credentials
            $credentialsJson = json_encode($credentialsData);
            $encryptedCredentials = base64_encode(openssl_encrypt(
                $credentialsJson,
                'AES-256-CBC',
                hash('sha256', $encryptionKey),
                0,
                substr(hash('sha256', $encryptionKey), 0, 16)
            ));
            
            // Check if credentials already exist
            $stmt = $db->prepare("SELECT id FROM api_credentials WHERE user_id = ? AND service_name = ?");
            $stmt->execute([$userId, $serviceName]);
            $existing = $stmt->fetch();
            
            if ($existing) {
                // Update existing
                $stmt = $db->prepare("
                    UPDATE api_credentials 
                    SET credential_value = ?, credential_key = ?, updated_at = NOW()
                    WHERE user_id = ? AND service_name = ?
                ");
                $stmt->execute([$encryptedCredentials, $credentialKey, $userId, $serviceName]);
            } else {
                // Insert new
                $stmt = $db->prepare("
                    INSERT INTO api_credentials (user_id, service_name, credential_key, credential_value, is_encrypted, status)
                    VALUES (?, ?, ?, ?, 1, 'active')
                ");
                $stmt->execute([$userId, $serviceName, $credentialKey, $encryptedCredentials]);
            }
            
            setFlashMessage('success', ucfirst(str_replace('_', ' ', $serviceName)) . ' credentials saved successfully!');
        } else {
            setFlashMessage('info', 'Please fill at least one required field to save credentials.');
        }
    }
}

header('Location: ' . url('client/settings.php'));
exit;

