<?php
/**
 * Client Lead Capture Form
 * Allows clients to capture leads with affiliate tracking
 */

require_once __DIR__ . '/../includes/auth.php';
require_once __DIR__ . '/../includes/functions.php';
require_once __DIR__ . '/../includes/csrf.php';

requireClient();
$pageTitle = 'Lead Capture';

$db = getDB();
$error = '';
$success = '';

// Handle form submission
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    requireCSRFToken();
    
    $email = trim($_POST['email'] ?? '');
    $name = trim($_POST['name'] ?? '');
    $phone = trim($_POST['phone'] ?? '');
    $companyName = trim($_POST['company_name'] ?? '');
    $notes = trim($_POST['notes'] ?? '');
    
    if (empty($email) || !filter_var($email, FILTER_VALIDATE_EMAIL)) {
        $error = 'Valid email address is required';
    } else {
        try {
            require_once __DIR__ . '/../includes/LeadCapture.php';
            $leadCapture = new LeadCapture();
            
            $result = $leadCapture->captureLead([
                'email' => $email,
                'name' => $name,
                'phone' => $phone,
                'company_name' => $companyName,
                'notes' => $notes
            ]);
            
            if ($result['success']) {
                $success = 'Lead captured successfully!';
                if (isset($result['affiliate']) && $result['affiliate']) {
                    $success .= ' This lead was attributed to an affiliate partner.';
                }
            } else {
                $error = $result['error'] ?? 'Failed to capture lead';
            }
        } catch (Exception $e) {
            $error = 'Error capturing lead: ' . $e->getMessage();
        }
    }
}

require_once __DIR__ . '/../includes/header.php';
?>

<div class="row mb-4">
    <div class="col-12">
        <h1><i class="bi bi-person-plus"></i> Lead Capture</h1>
        <p class="text-muted">Capture leads from your website or marketing campaigns</p>
    </div>
</div>

<?php if ($error): ?>
    <div class="alert alert-danger alert-dismissible fade show" role="alert">
        <?= escape($error) ?>
        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    </div>
<?php endif; ?>

<?php if ($success): ?>
    <div class="alert alert-success alert-dismissible fade show" role="alert">
        <?= escape($success) ?>
        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    </div>
<?php endif; ?>

<div class="row">
    <div class="col-md-8">
        <div class="card">
            <div class="card-header">
                <h5 class="mb-0">Capture New Lead</h5>
            </div>
            <div class="card-body">
                <form method="POST">
                    <?= csrfField() ?>
                    
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label for="name" class="form-label">Name</label>
                            <input type="text" class="form-control" id="name" name="name" 
                                   value="<?= escape($_POST['name'] ?? '') ?>" required>
                        </div>
                        <div class="col-md-6 mb-3">
                            <label for="email" class="form-label">Email <span class="text-danger">*</span></label>
                            <input type="email" class="form-control" id="email" name="email" 
                                   value="<?= escape($_POST['email'] ?? '') ?>" required>
                        </div>
                    </div>
                    
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label for="phone" class="form-label">Phone</label>
                            <input type="tel" class="form-control" id="phone" name="phone" 
                                   value="<?= escape($_POST['phone'] ?? '') ?>">
                        </div>
                        <div class="col-md-6 mb-3">
                            <label for="company_name" class="form-label">Company Name</label>
                            <input type="text" class="form-control" id="company_name" name="company_name" 
                                   value="<?= escape($_POST['company_name'] ?? '') ?>">
                        </div>
                    </div>
                    
                    <div class="mb-3">
                        <label for="notes" class="form-label">Notes</label>
                        <textarea class="form-control" id="notes" name="notes" rows="3" 
                                  placeholder="Additional notes about this lead..."><?= escape($_POST['notes'] ?? '') ?></textarea>
                    </div>
                    
                    <div class="d-grid">
                        <button type="submit" class="btn btn-primary">
                            <i class="bi bi-person-plus"></i> Capture Lead
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    
    <div class="col-md-4">
        <div class="card">
            <div class="card-header">
                <h5 class="mb-0">Lead Capture Code</h5>
            </div>
            <div class="card-body">
                <p class="text-muted">Use this code on your website to capture leads:</p>
                
                <div class="mb-3">
                    <label for="embedCode" class="form-label">Embed Code</label>
                    <textarea class="form-control" id="embedCode" rows="8" readonly><form action="<?= url('api/affiliate_tracking.php?action=capture_lead') ?>" method="POST" class="lead-capture-form">
    <div class="mb-3">
        <input type="text" name="name" class="form-control" placeholder="Full Name" required>
    </div>
    <div class="mb-3">
        <input type="email" name="email" class="form-control" placeholder="Email Address" required>
    </div>
    <div class="mb-3">
        <input type="tel" name="phone" class="form-control" placeholder="Phone Number">
    </div>
    <div class="mb-3">
        <input type="text" name="company_name" class="form-control" placeholder="Company Name">
    </div>
    <div class="mb-3">
        <textarea name="notes" class="form-control" rows="3" placeholder="Additional Notes"></textarea>
    </div>
    <button type="submit" class="btn btn-primary w-100">Submit Lead</button>
</form>

<script>
document.querySelector('.lead-capture-form').addEventListener('submit', function(e) {
    e.preventDefault();
    const formData = new FormData(this);
    
    fetch('<?= url('api/affiliate_tracking.php?action=capture_lead') ?>', {
        method: 'POST',
        body: formData
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            alert('Lead captured successfully!');
            this.reset();
        } else {
            alert('Error: ' + (data.error || 'Failed to capture lead'));
        }
    })
    .catch(error => {
        alert('Error: ' + error.message);
    });
});
</script></textarea>
                </div>
                
                <button class="btn btn-outline-secondary btn-sm" onclick="copyEmbedCode()">
                    <i class="bi bi-copy"></i> Copy Code
                </button>
            </div>
        </div>
        
        <div class="card mt-3">
            <div class="card-header">
                <h5 class="mb-0">JavaScript API</h5>
            </div>
            <div class="card-body">
                <p class="text-muted">Track leads programmatically:</p>
                <pre class="bg-light p-2 rounded"><code>// Track affiliate click
fetch('<?= url('api/affiliate_tracking.php') ?>?action=track_click&ref=PARTNER_CODE')
  .then(response => response.json())
  .then(data => console.log(data));

// Capture lead
fetch('<?= url('api/affiliate_tracking.php') ?>?action=capture_lead', {
  method: 'POST',
  headers: {'Content-Type': 'application/x-www-form-urlencoded'},
  body: 'email=test@example.com&name=John Doe'
})
  .then(response => response.json())
  .then(data => console.log(data));</code></pre>
            </div>
        </div>
    </div>
</div>

<script>
function copyEmbedCode() {
    const embedCode = document.getElementById('embedCode');
    embedCode.select();
    embedCode.setSelectionRange(0, 99999);
    
    try {
        document.execCommand('copy');
        const button = event.target;
        const originalHTML = button.innerHTML;
        button.innerHTML = '<i class="bi bi-check"></i> Copied!';
        button.classList.remove('btn-outline-secondary');
        button.classList.add('btn-success');
        
        setTimeout(() => {
            button.innerHTML = originalHTML;
            button.classList.remove('btn-success');
            button.classList.add('btn-outline-secondary');
        }, 2000);
    } catch (err) {
        alert('Failed to copy code');
    }
}
</script>

<?php require_once __DIR__ . '/../includes/footer.php'; ?>
