<?php
/**
 * Download Email Import Template CSV
 * Provides a sample CSV file with proper headers for email list imports
 */

require_once __DIR__ . '/../includes/auth.php';
requireClient();

// Set headers for CSV download
header('Content-Type: text/csv; charset=utf-8');
header('Content-Disposition: attachment; filename="email_import_template_' . date('Y-m-d') . '.csv"');
header('Pragma: no-cache');
header('Expires: 0');

// Create output stream
$output = fopen('php://output', 'w');

// Add UTF-8 BOM for Excel compatibility
fprintf($output, chr(0xEF).chr(0xBB).chr(0xBF));

// Write header row
fputcsv($output, ['Email', 'First Name', 'Last Name', 'Phone'], ',');

// Write sample data rows (example entries)
$sampleData = [
    ['john.doe@example.com', 'John', 'Doe', '555-0100'],
    ['jane.smith@example.com', 'Jane', 'Smith', '555-0101'],
    ['bob.johnson@example.com', 'Bob', 'Johnson', '555-0102'],
];

foreach ($sampleData as $row) {
    fputcsv($output, $row, ',');
}

// Close output stream
fclose($output);
exit;

