/**
 * Marketing Platform Main JavaScript
 */

// Auto-hide flash messages after 5 seconds
document.addEventListener('DOMContentLoaded', function() {
    const alerts = document.querySelectorAll('.alert');
    alerts.forEach(function(alert) {
        setTimeout(function() {
            const bsAlert = new bootstrap.Alert(alert);
            bsAlert.close();
        }, 5000);
    });
    
    // Confirm delete actions
    const deleteButtons = document.querySelectorAll('[data-confirm-delete]');
    deleteButtons.forEach(function(button) {
        button.addEventListener('click', function(e) {
            if (!confirm('Are you sure you want to delete this item?')) {
                e.preventDefault();
            }
        });
    });
});

// Tracking pixel for metrics (1x1 transparent image)
function trackMetric(userId, params) {
    const img = new Image();
    const queryParams = new URLSearchParams({
        user_id: userId,
        ...params
    });
    img.src = '/api/metrics_tracking.php?' + queryParams.toString();
}

// Track page views automatically if user_id is set
if (typeof TRACKING_USER_ID !== 'undefined') {
    trackMetric(TRACKING_USER_ID, {
        url: window.location.href,
        ref: document.referrer,
        utm_source: new URLSearchParams(window.location.search).get('utm_source'),
        utm_medium: new URLSearchParams(window.location.search).get('utm_medium'),
        utm_campaign: new URLSearchParams(window.location.search).get('utm_campaign'),
        utm_term: new URLSearchParams(window.location.search).get('utm_term'),
        utm_content: new URLSearchParams(window.location.search).get('utm_content')
    });
}

