<?php
/**
 * REST API v1 - Campaigns Resource
 */

$method = $_SERVER['REQUEST_METHOD'];
$userId = $_SESSION['user_id'];
$db = getDB();

try {
    switch ($method) {
        case 'GET':
            if ($resourceId) {
                // Get single campaign
                $stmt = $db->prepare("SELECT * FROM campaigns WHERE id = ? AND user_id = ?");
                $stmt->execute([$resourceId, $userId]);
                $campaign = $stmt->fetch();
                
                if (!$campaign) {
                    http_response_code(404);
                    echo json_encode(['success' => false, 'error' => 'Campaign not found']);
                    exit;
                }
                
                echo json_encode(['success' => true, 'data' => $campaign]);
            } else {
                // List campaigns
                $stmt = $db->prepare("SELECT * FROM campaigns WHERE user_id = ? ORDER BY created_at DESC");
                $stmt->execute([$userId]);
                $campaigns = $stmt->fetchAll();
                
                echo json_encode(['success' => true, 'data' => $campaigns]);
            }
            break;
            
        case 'POST':
            $data = json_decode(file_get_contents('php://input'), true);
            
            $stmt = $db->prepare("
                INSERT INTO campaigns (user_id, campaign_name, campaign_type, budget, start_date, end_date, description, status)
                VALUES (?, ?, ?, ?, ?, ?, ?, 'draft')
            ");
            $stmt->execute([
                $userId,
                $data['campaign_name'] ?? '',
                $data['campaign_type'] ?? '',
                $data['budget'] ?? null,
                $data['start_date'] ?? null,
                $data['end_date'] ?? null,
                $data['description'] ?? ''
            ]);
            
            $campaignId = $db->lastInsertId();
            echo json_encode(['success' => true, 'data' => ['id' => $campaignId]]);
            break;
            
        case 'PUT':
            if (!$resourceId) {
                http_response_code(400);
                echo json_encode(['success' => false, 'error' => 'Campaign ID required']);
                exit;
            }
            
            $data = json_decode(file_get_contents('php://input'), true);
            
            // Update campaign
            $updates = [];
            $params = [];
            
            if (isset($data['campaign_name'])) {
                $updates[] = "campaign_name = ?";
                $params[] = $data['campaign_name'];
            }
            if (isset($data['status'])) {
                $updates[] = "status = ?";
                $params[] = $data['status'];
            }
            
            if (empty($updates)) {
                http_response_code(400);
                echo json_encode(['success' => false, 'error' => 'No fields to update']);
                exit;
            }
            
            $params[] = $resourceId;
            $params[] = $userId;
            
            $stmt = $db->prepare("
                UPDATE campaigns 
                SET " . implode(', ', $updates) . ", updated_at = NOW()
                WHERE id = ? AND user_id = ?
            ");
            $stmt->execute($params);
            
            echo json_encode(['success' => true]);
            break;
            
        case 'DELETE':
            if (!$resourceId) {
                http_response_code(400);
                echo json_encode(['success' => false, 'error' => 'Campaign ID required']);
                exit;
            }
            
            $stmt = $db->prepare("DELETE FROM campaigns WHERE id = ? AND user_id = ?");
            $stmt->execute([$resourceId, $userId]);
            
            echo json_encode(['success' => true]);
            break;
    }
} catch (Exception $e) {
    http_response_code(400);
    echo json_encode(['success' => false, 'error' => $e->getMessage()]);
}

