<?php
/**
 * Affiliates Pages Index
 * Lists all generated affiliate marketing websites
 */

session_start();

if (!isset($_SESSION['loggedin']) || $_SESSION['loggedin'] !== true) {
    header('Location: ../ad-generator/index.php');
    exit;
}

$affiliatesDir = __DIR__;
$files = glob($affiliatesDir . '/*.html');
$websites = [];

foreach ($files as $file) {
    $filename = basename($file);
    $websites[] = [
        'filename' => $filename,
        'name' => str_replace(['ad_', '.html'], ['', ''], $filename),
        'size' => filesize($file),
        'modified' => filemtime($file),
        'url' => $filename
    ];
}

// Sort by modification time (newest first)
usort($websites, function($a, $b) {
    return $b['modified'] - $a['modified'];
});

function formatFileSize($bytes) {
    if ($bytes >= 1048576) {
        return round($bytes / 1048576, 2) . ' MB';
    } elseif ($bytes >= 1024) {
        return round($bytes / 1024, 2) . ' KB';
    } else {
        return $bytes . ' bytes';
    }
}

function formatDate($timestamp) {
    return date('M j, Y g:i A', $timestamp);
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Affiliate Marketing Websites - Marketing Platform</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.0/font/bootstrap-icons.css">
</head>
<body class="bg-gray-900 text-white">
    <div class="container mx-auto px-4 py-8">
        <header class="mb-8">
            <div class="flex items-center justify-between">
                <div>
                    <h1 class="text-4xl font-bold text-cyan-400">Affiliate Marketing Websites</h1>
                    <p class="text-gray-400 mt-2">Generated websites for affiliate marketing campaigns</p>
                </div>
                <div class="flex gap-4">
                    <a href="../ad-generator/ad-generator.php" class="bg-blue-600 hover:bg-blue-700 text-white px-6 py-3 rounded-lg transition-colors">
                        <i class="bi bi-plus-circle"></i> Generate New Website
                    </a>
                    <a href="../ad-generator/index.php" class="bg-gray-600 hover:bg-gray-700 text-white px-6 py-3 rounded-lg transition-colors">
                        <i class="bi bi-arrow-left"></i> Back to Dashboard
                    </a>
                </div>
            </div>
        </header>

        <?php if (empty($websites)): ?>
            <div class="text-center py-12">
                <i class="bi bi-folder-open text-6xl text-gray-600 mb-4"></i>
                <h3 class="text-xl font-semibold text-gray-400 mb-2">No websites generated yet</h3>
                <p class="text-gray-500 mb-6">Start by generating your first affiliate marketing website</p>
                <a href="../ad-generator/ad-generator.php" class="bg-blue-600 hover:bg-blue-700 text-white px-6 py-3 rounded-lg transition-colors">
                    <i class="bi bi-plus-circle"></i> Generate Website
                </a>
            </div>
        <?php else: ?>
            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
                <?php foreach ($websites as $website): ?>
                    <div class="bg-gray-800 rounded-lg p-6 border border-gray-700 hover:border-cyan-500 transition-colors">
                        <div class="flex items-start justify-between mb-4">
                            <div>
                                <h3 class="text-lg font-semibold text-white mb-1">
                                    <?= htmlspecialchars($website['name']) ?>
                                </h3>
                                <p class="text-sm text-gray-400">
                                    <?= formatFileSize($website['size']) ?> • <?= formatDate($website['modified']) ?>
                                </p>
                            </div>
                            <div class="flex gap-2">
                                <a href="<?= htmlspecialchars($website['url']) ?>" target="_blank" 
                                   class="text-blue-400 hover:text-blue-300" title="View Website">
                                    <i class="bi bi-eye"></i>
                                </a>
                                <a href="<?= htmlspecialchars($website['url']) ?>" download 
                                   class="text-green-400 hover:text-green-300" title="Download">
                                    <i class="bi bi-download"></i>
                                </a>
                            </div>
                        </div>
                        
                        <div class="mb-4">
                            <iframe src="<?= htmlspecialchars($website['url']) ?>" 
                                    class="w-full h-48 border border-gray-600 rounded"
                                    style="pointer-events: none;"></iframe>
                        </div>
                        
                        <div class="flex gap-2">
                            <a href="<?= htmlspecialchars($website['url']) ?>" target="_blank" 
                               class="flex-1 bg-blue-600 hover:bg-blue-700 text-white text-center py-2 px-4 rounded transition-colors">
                                <i class="bi bi-eye"></i> View
                            </a>
                            <a href="<?= htmlspecialchars($website['url']) ?>" download 
                               class="flex-1 bg-green-600 hover:bg-green-700 text-white text-center py-2 px-4 rounded transition-colors">
                                <i class="bi bi-download"></i> Download
                            </a>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
        <?php endif; ?>
    </div>
</body>
</html>
