<?php
/**
 * Admin - View Client Dashboard
 * Allows admins to view client dashboards and manage their accounts
 */

require_once __DIR__ . '/../includes/auth.php';
require_once __DIR__ . '/../includes/functions.php';

requireAdmin();
$pageTitle = 'View Client Dashboard';

$db = getDB();
$adminId = $_SESSION['user_id'];

// Get client ID
$clientId = isset($_GET['client_id']) ? intval($_GET['client_id']) : 0;

if (!$clientId) {
    setFlashMessage('danger', 'Client ID is required');
    header('Location: ' . url('admin/clients.php'));
    exit;
}

// Verify admin has access to this client
if (!adminHasClientAccess($adminId, $clientId)) {
    setFlashMessage('danger', 'You do not have access to this client.');
    header('Location: ' . url('admin/clients.php'));
    exit;
}

// Get client info
$stmt = $db->prepare("SELECT * FROM users WHERE id = ? AND role = 'client'");
$stmt->execute([$clientId]);
$client = $stmt->fetch();

if (!$client) {
    setFlashMessage('danger', 'Client not found');
    header('Location: ' . url('admin/clients.php'));
    exit;
}

// Set session to view as this client
$_SESSION['viewing_as_client_id'] = $clientId;

// Redirect to client dashboard
header('Location: ' . url('client/dashboard.php'));
exit;

