<?php
/**
 * Admin - Subscription Management
 */

require_once __DIR__ . '/../includes/auth.php';
require_once __DIR__ . '/../includes/functions.php';

requireAdmin();
$pageTitle = 'Subscription Management';

$db = getDB();

// Get all subscriptions
$stmt = $db->query("
    SELECT s.*, u.business_name, u.email, st.tier_name, st.monthly_price
    FROM subscriptions s
    JOIN users u ON s.user_id = u.id
    JOIN subscription_tiers st ON s.tier_id = st.id
    ORDER BY s.created_at DESC
");
$subscriptions = $stmt->fetchAll();

// Get all tiers for dropdown
$stmt = $db->query("SELECT * FROM subscription_tiers ORDER BY tier_level");
$tiers = $stmt->fetchAll();

require_once __DIR__ . '/../includes/header.php';
?>

<div class="row">
    <div class="col-12 mb-4">
        <h1>Subscription Management</h1>
    </div>
</div>

<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-striped">
                        <thead>
                            <tr>
                                <th>Client</th>
                                <th>Tier</th>
                                <th>Start Date</th>
                                <th>Renewal Date</th>
                                <th>Status</th>
                                <th>Monthly Price</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($subscriptions as $sub): ?>
                                <tr>
                                    <td>
                                        <strong><?= escape($sub['business_name']) ?></strong><br>
                                        <small class="text-muted"><?= escape($sub['email']) ?></small>
                                    </td>
                                    <td><span class="badge bg-primary"><?= escape($sub['tier_name']) ?></span></td>
                                    <td><?= formatDate($sub['start_date']) ?></td>
                                    <td><?= formatDate($sub['renewal_date']) ?></td>
                                    <td>
                                        <span class="badge bg-<?= $sub['status'] === 'active' ? 'success' : 'secondary' ?>">
                                            <?= escape($sub['status']) ?>
                                        </span>
                                    </td>
                                    <td><?= formatCurrency($sub['monthly_price']) ?></td>
                                    <td>
                                        <button class="btn btn-sm btn-primary" data-bs-toggle="modal" data-bs-target="#editModal<?= $sub['id'] ?>">
                                            Edit
                                        </button>
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>

<?php require_once __DIR__ . '/../includes/footer.php'; ?>

