<?php
/**
 * Admin Login Page (admins only)
 */

require_once __DIR__ . '/../includes/auth.php';
require_once __DIR__ . '/../includes/functions.php';
require_once __DIR__ . '/../includes/csrf.php';

// Ensure base path is loaded
getBasePath();

$auth = new Auth();
$error = '';

// Redirect if already logged in
if ($auth->isLoggedIn()) {
    $role = $_SESSION['user_role'];
    header('Location: ' . url($role === 'admin' ? 'admin/dashboard.php' : 'client/dashboard.php'));
    exit;
}

// Handle login form submission
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    requireCSRFToken();
    $email = $_POST['email'] ?? '';
    $password = $_POST['password'] ?? '';
    
    if (!empty($email) && !empty($password)) {
        if ($auth->login($email, $password)) {
            $role = $_SESSION['user_role'] ?? null;
            if ($role === 'admin') {
                header('Location: ' . url('admin/dashboard.php'));
                exit;
            }
            // Not an admin, logout and show error
            $auth->logout();
            $error = 'This portal is for administrators only. Clients use /login.php, Affiliates use /partner/login.php';
        } else {
            $error = 'Invalid email or password';
        }
    } else {
        $error = 'Please fill in all fields';
    }
}

$flash = getFlashMessage();
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Login - Marketing Platform</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="<?= url('assets/css/style.css') ?>">
</head>
<body class="bg-light">
    <div class="container">
        <div class="row justify-content-center align-items-center min-vh-100">
            <div class="col-md-5">
                <div class="card shadow">
                    <div class="card-body p-5">
                        <h2 class="text-center mb-4">Marketing Platform</h2>
                        <h4 class="text-center mb-4 text-muted">Admin Login</h4>
                        
                        <?php if ($error): ?>
                            <div class="alert alert-danger"><?= escape($error) ?></div>
                        <?php endif; ?>
                        
                        <?php if ($flash): ?>
                            <div class="alert alert-<?= escape($flash['type']) ?>"><?= escape($flash['message']) ?></div>
                        <?php endif; ?>
                        
                        <form method="POST" action="<?= url('admin/login.php') ?>">
                            <?= csrfField() ?>
                            <div class="mb-3">
                                <label for="email" class="form-label">Email Address</label>
                                <input type="email" class="form-control" id="email" name="email" required autofocus>
                            </div>
                            
                            <div class="mb-3">
                                <label for="password" class="form-label">Password</label>
                                <input type="password" class="form-control" id="password" name="password" required>
                            </div>
                            
                            <button type="submit" class="btn btn-primary w-100">Login</button>
                        </form>

                        <div class="text-center mt-3">
                            <small class="text-muted">Clients: <a href="<?= url('login.php') ?>">Client Login</a> · Affiliates: <a href="<?= url('partner/login.php') ?>">Partner Login</a></small>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>


