<?php
/**
 * Admin Dashboard
 */

require_once __DIR__ . '/../includes/auth.php';
require_once __DIR__ . '/../includes/functions.php';

requireAdmin();
$pageTitle = 'Admin Dashboard';

$db = getDB();

// Get statistics
$stmt = $db->query("SELECT COUNT(*) as count FROM users WHERE role = 'client' AND status = 'active'");
$totalClients = $stmt->fetchColumn();

$stmt = $db->query("SELECT COUNT(*) as count FROM subscriptions WHERE status = 'active'");
$activeSubscriptions = $stmt->fetchColumn();

$stmt = $db->query("
    SELECT SUM(st.monthly_price) as total_revenue
    FROM subscriptions s
    JOIN subscription_tiers st ON s.tier_id = st.id
    WHERE s.status = 'active'
");
$monthlyRevenue = $stmt->fetchColumn() ?? 0;

$stmt = $db->query("SELECT COUNT(*) as count FROM campaigns WHERE status = 'active'");
$activeCampaigns = $stmt->fetchColumn();

// Get recent clients
$stmt = $db->query("
    SELECT u.*, s.status as subscription_status, st.tier_name
    FROM users u
    LEFT JOIN subscriptions s ON u.id = s.user_id AND s.status = 'active'
    LEFT JOIN subscription_tiers st ON s.tier_id = st.id
    WHERE u.role = 'client'
    ORDER BY u.created_at DESC
    LIMIT 5
");
$recentClients = $stmt->fetchAll();

// Get revenue by tier
$stmt = $db->query("
    SELECT st.tier_name, COUNT(s.id) as count, SUM(st.monthly_price) as revenue
    FROM subscription_tiers st
    LEFT JOIN subscriptions s ON st.id = s.tier_id AND s.status = 'active'
    GROUP BY st.id, st.tier_name
    ORDER BY st.tier_level
");
$revenueByTier = $stmt->fetchAll();

require_once __DIR__ . '/../includes/header.php';
?>

<div class="row">
    <div class="col-12 mb-4">
        <h1>Admin Dashboard</h1>
        <p class="text-muted">System Overview</p>
    </div>
</div>

<!-- Key Metrics -->
<div class="row mb-4">
    <div class="col-md-3 mb-3">
        <div class="card text-white bg-primary">
            <div class="card-body">
                <h5 class="card-title">Total Clients</h5>
                <h2 class="mb-0"><?= number_format($totalClients) ?></h2>
                <small>Active clients</small>
            </div>
        </div>
    </div>
    <div class="col-md-3 mb-3">
        <div class="card text-white bg-success">
            <div class="card-body">
                <h5 class="card-title">Active Subscriptions</h5>
                <h2 class="mb-0"><?= number_format($activeSubscriptions) ?></h2>
                <small>Currently active</small>
            </div>
        </div>
    </div>
    <div class="col-md-3 mb-3">
        <div class="card text-white bg-info">
            <div class="card-body">
                <h5 class="card-title">Monthly Revenue</h5>
                <h2 class="mb-0"><?= formatCurrency($monthlyRevenue) ?></h2>
                <small>Recurring revenue</small>
            </div>
        </div>
    </div>
    <div class="col-md-3 mb-3">
        <div class="card text-white bg-warning">
            <div class="card-body">
                <h5 class="card-title">Active Campaigns</h5>
                <h2 class="mb-0"><?= number_format($activeCampaigns) ?></h2>
                <small>Running campaigns</small>
            </div>
        </div>
    </div>
</div>

<!-- Revenue by Tier -->
<div class="row mb-4">
    <div class="col-md-6">
        <div class="card">
            <div class="card-header">
                <h5 class="mb-0">Subscriptions by Tier</h5>
            </div>
            <div class="card-body">
                <table class="table">
                    <thead>
                        <tr>
                            <th>Tier</th>
                            <th>Subscribers</th>
                            <th>Monthly Revenue</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($revenueByTier as $tier): ?>
                            <tr>
                                <td><strong><?= escape($tier['tier_name']) ?></strong></td>
                                <td><?= number_format($tier['count']) ?></td>
                                <td><?= formatCurrency($tier['revenue'] ?? 0) ?></td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
    
    <div class="col-md-6">
        <div class="card">
            <div class="card-header d-flex justify-content-between align-items-center">
                <h5 class="mb-0">Recent Clients</h5>
                <a href="/admin/clients.php" class="btn btn-sm btn-outline-primary">View All</a>
            </div>
            <div class="card-body">
                <?php if (empty($recentClients)): ?>
                    <p class="text-muted mb-0">No clients yet.</p>
                <?php else: ?>
                    <div class="list-group list-group-flush">
                        <?php foreach ($recentClients as $client): ?>
                            <div class="list-group-item">
                                <div class="d-flex w-100 justify-content-between">
                                    <h6 class="mb-1"><?= escape($client['business_name']) ?></h6>
                                    <?php if ($client['subscription_status'] === 'active'): ?>
                                        <span class="badge bg-success"><?= escape($client['tier_name'] ?? 'No Plan') ?></span>
                                    <?php else: ?>
                                        <span class="badge bg-secondary">No Active Plan</span>
                                    <?php endif; ?>
                                </div>
                                <p class="mb-1"><small><?= escape($client['email']) ?></small></p>
                                <small class="text-muted">Joined: <?= formatDate($client['created_at']) ?></small>
                            </div>
                        <?php endforeach; ?>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>

<?php require_once __DIR__ . '/../includes/footer.php'; ?>

