<?php
/**
 * Admin - All Campaigns Overview
 */

require_once __DIR__ . '/../includes/auth.php';
require_once __DIR__ . '/../includes/functions.php';

requireAdmin();
$pageTitle = 'All Campaigns';

$db = getDB();

// Get all campaigns across all clients
$stmt = $db->query("
    SELECT c.*, u.business_name
    FROM campaigns c
    JOIN users u ON c.user_id = u.id
    ORDER BY c.created_at DESC
");
$campaigns = $stmt->fetchAll();

require_once __DIR__ . '/../includes/header.php';
?>

<div class="row">
    <div class="col-12 mb-4">
        <h1>All Campaigns</h1>
        <p class="text-muted">Oversee allский campaigns across all clients</p>
    </div>
</div>

<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-striped">
                        <thead>
                            <tr>
                                <th>Campaign Name</th>
                                <th>Client</th>
                                <th>Type</th>
                                <th>Status</th>
                                <th>Budget</th>
                                <th>Created</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($campaigns as $campaign): ?>
                                <tr>
                                    <td><strong><?= escape($campaign['campaign_name']) ?></strong></td>
                                    <td><?= escape($campaign['business_name']) ?></td>
                                    <td><?= ucfirst(str_replace('_', ' ', $campaign['campaign_type'])) ?></td>
                                    <td>
                                        <span class="badge bg-<?= 
                                            $campaign['status'] === 'active' ? 'success' : 
                                            ($campaign['status'] === 'paused' ? 'warning' : 'secondary') 
                                        ?>">
                                            <?= escape($campaign['status']) ?>
                                        </span>
                                    </td>
                                    <td><?= $campaign['budget'] ? formatCurrency($campaign['budget']) : 'N/A' ?></td>
                                    <td><?= formatDate($campaign['created_at']) ?></td>
                                </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>

<?php require_once __DIR__ . '/../includes/footer.php'; ?>

